import React from 'react';
import { Modal, View, Text, TouchableOpacity, Image, StyleSheet } from 'react-native';
import { fp, hp, wp } from '../../helpers/Dimensions';
import { DROPICON, MAN, PICKICON, STAR } from '../../assets/Icon'
import Buttonwhite from '../../components/Buttonwhite'
import Buttonblack from '../../components/Buttonblack'
import { acceptRide, rejectRide } from '../../services/RideService';

const RideNew = ({ visible, onClose, handleModal, data }) => {

  const acceptRideFunc = async (rideId, is_queued=0) => {
          try {
              const acceptRideInfo  = await acceptRide(rideId, 0, is_queued);
              console.log("ridenew13=== ", acceptRideInfo);
              
              if(acceptRideInfo){
                  
                  if(acceptRideInfo?.status_name == 'QUEUED'){
                    onClose();
                  } 
              }            
  
          } catch (error) {
              console.error("Error accepting ride:", error);
          }
      };

    const cancleRideFunc = async (rideId) => {
        const rejectRideResponse = await rejectRide(rideId);
        onClose();        
    }
      

  return (
    <Modal
    animationType="slide"
    transparent={true}
    visible={visible}
    onRequestClose={onClose}
            >
                <View style={styles.modalContainer}>
                    <View style={styles.modalView}>
                        <View style={styles.modalL1View}>
                            <View style={{ backgroundColor: "#FFFFFF", width: wp(20) }}>
                                {data?.user?.photo_url ? 
                                (
                                <Image source={{ uri: data?.user?.photo_url }} style={styles.profileImage} />
                                ):(
                                    <Image source={MAN} />
                                )}
                            </View>
                            <View style={{ width: wp(50) }}>
                                <Text style={styles.modalTextBold}>{data?.user?.name}</Text>
                                <Text style={styles.textSmall}>{data?.currency}{data?.final_price}</Text>
                            </View>
                            <View style={{ width: wp(20) }}></View>
                        </View>
                        <View style={styles.modalL1View}>
                            <View style={styles.modalL2View}>
                                <View style={{ width: wp(20), paddingLeft: 20 }}>
                                    <Image source={PICKICON} />
                                </View>
                                <View style={{ width: wp(50) }}>
                                    <Text style={styles.modalTextBold}>{data?.pickup_address}</Text>
                                    
                                </View>
                            </View>
                        </View>
                        <View style={styles.modalL1View}>
                            <View style={styles.modalL2View}>
                                <View style={{ width: wp(20), paddingLeft: 20 }}>
                                    <Image source={DROPICON} />
                                </View>
                                <View style={{ width: wp(50) }}>
                                    <Text style={styles.modalTextBold}>{data?.delivery_address}</Text>
                                    
                                </View>
                            </View>
                        </View>
                        <View style={styles.buttonContainer}>
        <Buttonwhite
          title="Decline"
          wide="40"
          onPress={() => handleDecline(data?.id)}
        />
        <Buttonblack
          title="Accept"
          wide="40"
          onPress={() => acceptRideFunc(data?.id, data?.queued)}
        />
      </View>
                    </View>
                </View>
            </Modal>
    
  );
};

export default RideNew;

const styles = StyleSheet.create({
    modalContainer: {
        flex: 1,
        justifyContent: "flex-end",
        margin: 10
    },
    modalView: {
        backgroundColor: "#FFFFFF",
        borderRadius: 20,
        width: wp(95),
        //height: hp(40),
        alignSelf: "center",
        paddingTop: 10,
        paddingBottom: 10
    },
    modalL1View: {
        backgroundColor: "#FFFFFF",
        flexDirection: "row",
        justifyContent: "space-between",
        width: wp(90),
        //height: hp(25),
        margin: 10
    },
    modalL2View: {
        backgroundColor: "#FFFFFF",
        //width: wp(90),
        //alignSelf: "center",
        flexDirection: "row",
        justifyContent: "space-between"
    },
    modalTextBold: {
        fontSize: fp(2),
        fontWeight: "bold",
        color: "#000000",
    },
    modalText: {
        fontSize: fp(2),
        color: "#000000",
    },
    modalBtnContainer: {
        backgroundColor: "#FFFFFF",
        width: wp(90),
        alignSelf: "center",
        //flexDirection: "row",
        justifyContent: "center",
        alignItems: "center"
    },
    starContainer: {
        width: wp(30),
        flexDirection: "row",
        justifyContent: "space-evenly"
    },
    greyline: {
        backgroundColor: "lightgrey",
        color: "lightgrey",
        alignSelf: "center",
        width: wp(30),
        height: hp(0.7),
        //paddingTop: 10
    },
    modalFeedbackContainer: {
        flex: 1,
        justifyContent: "flex-end",
        margin: 0
    },
    modalFeedbackView: {
        backgroundColor: "#FFFFFF",
        borderRadius: 20,
        width: wp(95),
        height: hp(55),
        alignItems: "center",
        alignSelf: "center",
        paddingTop: 10
    },
    otpContainer: {
        width: wp(90),
        alignItems: "center",
        margin: 10
    },
    textSmall: {
        color: "#000000",
    },
    txtSmall: {
        color: "#000000",
        fontSize: fp(1.5),
    },
    txtSmallBold: {
        color: "#000000",
        fontSize: fp(1.5),
        fontWeight: "bold"
    },
    txtNormal: {
        color: "#000000",
        fontSize: fp(2),
    },
    txtNormalBold: {
        color: "#000000",
        fontSize: fp(2),
        fontWeight: "bold"
    },
    txtNormalRed: {
        color: "red",
        fontSize: fp(2),
    },
    txtLarge: {
        color: "#000000",
        fontSize: fp(2.2),
    },
    txtLargeBold: {
        color: "#000000",
        fontSize: fp(2.2),
        fontWeight: "bold"
    },
    profileImage: {
        width: wp(10),
        height: hp(5),
        borderRadius: 25,
    },
    buttonContainer: {
        backgroundColor: "#FFFFFF",
        width: wp(90),
        alignSelf: "center",
        flexDirection: "row",
        justifyContent: "space-around",
        alignItems: "center"
    },
})