import { StyleSheet, Text, View, TextInput } from 'react-native'
import React from 'react'
import { hp, wp } from '../helpers/Dimensions'

const Textbox = (props) => {
    const {rfn, title, wide, val, changetext} = props

  return (
    <View style={styles.textBoxContainer}>
        <TextInput style={[styles.inpt, {width:wp(wide),}, props.inputstyle]}
        placeholder={title}
        //ref={rfn}
        onChangeText={changetext}
        value={val}
        />
    </View>

  )
}

export default Textbox

const styles = StyleSheet.create({
    textBoxContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(8),
        alignItems: "center",
        padding: 5
        
    },
    inpt: {
        width: wp(90),
        borderRadius: 15,
        borderWidth: 1,
        borderColor: "#223138",
        paddingHorizontal: 10        
    }

    
})