import { StyleSheet, Text, View, Image, TouchableOpacity } from 'react-native'
import React, { useEffect, useRef, useState } from 'react'
import MaterialIcons from 'react-native-vector-icons/MaterialIcons';
import { LOGO, MAN, STAR, STARFILLED, STARUNFILLED, STARWHITE } from '../../assets/Icon'
import { fp, hp, wp } from '../../helpers/Dimensions'
import { Dropdown } from 'react-native-element-dropdown';
import Header from '../../components/Header';
import Buttonblack from '../../components/Buttonblack';
import { useNavigation } from '@react-navigation/native';
import Textarea from '../../components/Textarea';
import { feedback, initiateRides, rideSummary } from '../../services/RideService';
import RideNew from '../../components/models/RideNew'
import { RIDESTATUSHASH } from '../../config';

const Feedback = ({route}) => {
    const navigation = useNavigation()
    const[ride_summary, set_ride_summary] = useState(null);
    const [rating, setRating] = useState(0);
    const [comment, setComment] = useState('');
    const [activeModal, setActiveModal] = useState(null);
    const [modalData, setModalData] = useState(null);
    
    const intervalRef = useRef(null);

    useEffect(() => {
        rideSummaryCall()  
        
        intervalRef.current = setInterval(fetchNewRide, 2000);
        return () => clearInterval(intervalRef.current);

    }, [])

    const rideSummaryCall = async () => {
        const { ride_id } = route.params; 
        const rideSummaryData = await rideSummary(ride_id);
        set_ride_summary(rideSummaryData);

    }

    const handleSubmit = async() =>{
        var args = {};
        args['rating']  = rating;
        args['message'] = comment;
        const feedback_resp = await feedback(args);
        navigation.navigate("Dashboard");

    }
const handleModal = (data) => {
        console.log("Modal Action Triggered With:", data);
        setActiveModal(null);
    };

    const closeModal = () => {
        setActiveModal(null);
    };

    ////////////////////////////////////////
        const fetchNewRide = async () => {
            const initiateRidesResponse = await initiateRides();
            console.log("payment31=== ", initiateRidesResponse);
    
            if (!initiateRidesResponse || initiateRidesResponse.length === 0) return;
    
            const filtered = initiateRidesResponse.filter(ride => ride.status_name === 'PENDING')
                .map(ride => ({
                            ...ride,
                            queued: 1,
                })
            );
            
            if(filtered.length > 0 ){
                console.log("payment45===", filtered)
                var filtered_ride = filtered[0];
                var modify_status_name = filtered_ride?.queued == 1 ? 'QUEUED' : '';
    
                const config = RIDESTATUSHASH[modify_status_name];
                console.log("payment47===", config);
                if (config) {
                    setActiveModal(config.modal);
                    setModalData(filtered_ride);
                }
            }
    
            clearInterval(intervalRef.current);
                
        }

        const acceptRideFunc = async (rideId) => {

    }

    const handleDecline = async(rideId) => {

    }
    
    ////////////////////////////////////


    return (
        <View style={styles.mainContainer}>
            <Header title="Feedback" link="Documents" />
            <View style={styles.imgContainer}>
                <Image source={LOGO} />
            </View>
            <View style={styles.feedbackContainer}>
                <View style={styles.viewContainer}>
                    <View>
                        
                        <Image
                            source={{ uri: ride_summary?.user_photo}}
                            style={styles.image}
                            
                        />
                    </View>
                    <View style={{ marginLeft: 10 }}>
                        <View style={styles.starContainer}>
                            <Text style={styles.textH2}>{ride_summary?.pickup_name}</Text>
                            
                        </View>
                        <Text>{ride_summary?.time}</Text>
                    </View>
                </View>
                <View style={styles.breakline}></View>
                <View style={styles.reviewContainer}>
                    <Text style={styles.textH2}>How was your trip?</Text>
                    

<View style={styles.starContainer}>
                    {[1, 2, 3, 4, 5].map(star => (
  <TouchableOpacity key={star} onPress={() => setRating(star)}>
    <Image
      source={rating >= star ? STARFILLED : STARUNFILLED}
      style={{ width: 30, height: 30, margin: 5 }}
    />
  </TouchableOpacity>
))}
</View>
                    <Textarea title="Comment" wide="80" val={comment} changetext={setComment} />
                </View>

                <Buttonblack title="Feedback" wide="80" onPress={handleSubmit}/>
            </View>

            <RideNew
                    visible={activeModal === 'queued_ride'}
                    onClose={closeModal}
                    handleModal={handleModal}
                    data={modalData}
                    functionName={acceptRideFunc}
                    functionDelete={handleDecline}
            />

        </View>
    )
}

export default Feedback

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(30),
        justifyContent: "center",
        alignItems: "center"
    },
    feedbackContainer: {
        height: hp(50),
        width: wp(90),
        backgroundColor: '#fff',
        paddingHorizontal: 10,
        borderRadius: 15,
        // Shadow properties
        shadowColor: '#000',
        shadowOffset: { width: 0, height: 2 },
        shadowOpacity: 0.8,
        shadowRadius: 2,
        elevation: 5, // For Android shadow  
        alignSelf: "center",
        marginTop: 10
    },
    viewContainer: {
        //backgroundColor: "red",
        //height: hp(7),
        flexDirection: "row",
        justifyContent: "flex-start",
        marginTop: 25
    },
    starContainer: {
        flexDirection: "row",
        justifyContent: "flex-start",
    },
    reviewContainer: {
        width: wp(70),
        margin: 15,
        alignItems: "center",
        alignSelf: "center"
    },
    breakline: {
        height: hp(0.2),
        width: wp(80),
        backgroundColor: "lightgrey",
        alignSelf: "center",
        marginTop: 30
    },
    textH2: {
        fontSize: fp(2),
        fontWeight: "bold",
        color: "#000000",
        //paddingLeft: 5
    },
    textNormal: {
        fontSize: fp(1.5),
        color: "#000000"
    },
    image: {
    width: wp(5),
    height: hp(5),
    borderRadius: 50
  }

})