import { StyleSheet, Text, View, Image, ScrollView, FlatList, Button } from 'react-native'
import React, { useEffect, useState } from 'react'
import { fp, hp, wp } from '../../helpers/Dimensions'
import Header from '../../components/Header'
import Footer from '../../components/Footer'
import Buttonblack from '../../components/Buttonblack'
import { DROPICON, PICKICON, PIPEICON } from '../../assets/Icon'
import AsyncStorage from '@react-native-async-storage/async-storage';
import { acceptRide } from '../../services/RideService'

const Myrides = ({navigation}) => {
  const [data, setData] = useState([]);

  useEffect(() => {
    apiUrl = 'https://takeme.greathub.in/taxi/api/ride-history';
    var formdata = new FormData();

    formdata.append('api', 1);
    var requestOptions = {
      method: 'POST',
      body: formdata,
      redirect: 'follow',
    };
    // Fetch data from your API endpoint
    fetch(apiUrl, requestOptions)
      .then(response => response.json())
      .then(result => {
        //console.log(result);
        setData(result.data); // Update state with the fetched data
        console.log(data);
        //setIsLoading(false); // Set loading to false once data is fetched
      })
      .catch(error => console.error('Error fetching data:', error));
  }, []);

  const acceptRideFunc = async (rideId) => {
    try {
        
        const acceptRideInfo  = await acceptRide(rideId, 1);
        
        if(acceptRideInfo){
            await AsyncStorage.setItem('rideId', rideId.toString());    
            navigation.navigate("RideStepFirst");
        }            

    } catch (error) {
        console.error("Error accepting ride:", error);
    }
};


  // Render each item in the list
  const renderItem = ({ item }) => (
    <View style={styles.tripContainer}>

      <View style={styles.tripViewContainer}>
        <View>
          <Image source={PICKICON} />
          <Image source={PIPEICON} />
        </View>
        <View>
          <Text style={styles.textH2}>{item?.pickup_name}</Text>
          <Text style={styles.textSmall}>{item?.pickup_address}</Text>
          
        </View>
        <View style={{ width: wp(20) }}>
        </View>
      </View>
      <View style={styles.tripViewContainer}>
        <Image source={PIPEICON} />
      </View>
      <View style={styles.tripViewContainer}>
        <View>
          <Image source={DROPICON} />
        </View>
        <View>
          
          <Text style={styles.textSmall}>{item?.delivery_address}</Text>
          
        </View>
        <View style={{ width: wp(20) }}>
        </View>
      </View>
      <View style={styles.greyline}></View>
      <View style={styles.tripViewContainer}>
        <View>
          <Text style={styles.textH2}>{item?.currency_icon} {item?.final_price}</Text>
        </View>
      {item?.can_accept_ride ? (
        <Buttonblack title="Accept" wide="40" onPress={() => acceptRideFunc(item?.id)} />
      ) : 
        <View>
          
          <Buttonblack title={item?.ride_time} wide="60" />
           
        </View>
      }
      </View>
      { item?.schedule_ride && (
          <View>
          <Text style={{ fontSize: 12, color: '#888', marginTop: 4 }}>
            You can accept the ride 20 minutes before the scheduled time.
          </Text>
          </View>
      )}
    </View>

  );

  // Render empty component for FlatList
  const renderEmptyComponent = () => (
    <View style={{ alignItems: "center" }}>
      <Text style={styles.textH2}>There is no record</Text>
    </View>
  );

  return (
    <View style={styles.mainContainer}>
      <Header title="My Rides" link="Documents" />
      <View style={{ padding: 10 }}></View>
        <FlatList
          data={data}
          keyExtractor={(item) => item.id}
          renderItem={renderItem}
          ListEmptyComponent={renderEmptyComponent}
        />
        <Footer />
    </View>
  )
}

export default Myrides

const styles = StyleSheet.create({
  mainContainer: {
    backgroundColor: "#FFFFFF",
    height: hp(100),
    widht: wp(100)
  },
  imgContainer: {
    backgroundColor: "#FFFFFF",
    height: hp(10),
    justifyContent: "center",
    alignItems: "center"
  },
  tripContainer: {
    width: wp(90),
    height: hp(25),
    borderColor: "gray",
    borderWidth: 2,
    borderRadius: 15,
    alignSelf: "center"
  },
  tripViewContainer: {
    backgroundColor: "#FFFFFF",
    width: wp(85),
    flexDirection: "row",
    alignItems: "flex-start",
    alignSelf: "center",
    justifyContent: "space-between",
    padding: 3
  },
  textH3: {
    fontSize: fp(2.5),
    fontWeight: "bold",
    color: "#FFFFFF",
    //paddingLeft: 5
  },
  textH2: {
    fontSize: fp(2),
    fontWeight: "bold",
    color: "#000000",
    //paddingLeft: 5
  },
  textNormal: {
    fontSize: fp(1.5),
    color: "green",
    fontWeight: "bold"
  },
  textSmall: {
    fontSize: fp(1.5),
    color: "#000000"
  },
  greyline: {
    backgroundColor: "lightgrey",
    color: "lightgrey",
    alignSelf: "center",
    width: wp(90),
    height: hp(0.2)
  }

})