import { PermissionsAndroid, StyleSheet, Text, View, Image, Modal, ActivityIndicator } from 'react-native'
import React, { useEffect, useRef, useState } from 'react'
import Buttonblack from '../../components/Buttonblack'
import { useNavigation } from '@react-navigation/native';
import { fp, hp, wp } from '../../helpers/Dimensions'
import Header from '../../components/Header';
import { MAN } from '../../assets/Icon';
import MapView, { Marker, AnimatedRegion } from 'react-native-maps';
import MapViewDirections from 'react-native-maps-directions';
import { getDistance } from 'geolib';
import { GOOGLE_MAPS_API_KEY } from '../../config'; 

import RideService, { getAfterAcceptRide, startRide, updateDriverLatLong} from '../../services/RideService'
import { saveToStorage, getFromStorage } from '../../utils/storageHelper';

const Ridestart = () => {
    const navigation = useNavigation();
    const [modalVisible, setModalVisible] = useState(false);
    const [rideInfo, setRideInfo] = useState(null);
    const [pickupLocation, setPickupLocation] = useState(null);
    const [currentLocation, setCurrentLocation] = useState(null);
    const [driverLocation, setDriverLocation] = useState(null);
    const trackingInterval = useRef(null);

    useEffect(() => {
        fetchRecentRide();
    }, []);

    const storageRideId = async () => {
        try {
            const rideId = await getFromStorage('rideId');
            return rideId;
        } catch (error) {
            console.error("Error fetching rideId:", error);
            return null;
        }
    };

    const fetchRecentRide = async () => {
        //console.log("ridestart26");
        const rideId = await storageRideId();
        try {
            if(rideId){
                const inProcessRide = await getAfterAcceptRide(rideId);
                if (!inProcessRide || inProcessRide.length === 0) return;
    
                const ride = inProcessRide[0];
                if(ride.status == 9)
                {
                    setModalVisible(true);
                }
                setRideInfo(ride);

                console.log("ridestart35: ", ride);
                if (ride?.driver?.latitude && ride?.driver?.longitude) {
                    const initialDriverLocation = {
                        latitude: parseFloat(ride.driver.latitude),
                        longitude: parseFloat(ride.driver.longitude),
                    };
                    console.log("ridestart40:", initialDriverLocation);
                    setDriverLocation(initialDriverLocation);
                    setCurrentLocation(initialDriverLocation);
                }
    
                if (ride?.pickup_latitude && ride?.pickup_longitude) {
                    const userPickupLocation = {
                        latitude: parseFloat(ride.pickup_latitude),
                        longitude: parseFloat(ride.pickup_longitude),
                    };
                    setPickupLocation(userPickupLocation);
                }
                
            }

        } catch (error) {
            console.error("Error fetching ride data:", error);
        }
    }

    useEffect(() => {
        if (driverLocation && pickupLocation && rideInfo.status == 2) {
            startRideTracking(driverLocation, pickupLocation);
        }
    }, [driverLocation, pickupLocation]);

    const startRideTracking = (src, dest) => {
        if (!src || !dest) return;

        let progress = 0;
        const distance = getDistance(src, dest); // Calculate distance in meters
        const step = distance > 1000 ? 0.02 : 0.05; // Adjust movement step based on distance

        console.log("Starting Live Tracking...");

        trackingInterval.current = setInterval(() => {
            progress += step;

            const newLat = src.latitude + (dest.latitude - src.latitude) * progress;
            const newLng = src.longitude + (dest.longitude - src.longitude) * progress;
            const newPosition = { latitude: newLat, longitude: newLng };

            console.log("Updating Driver Location:", newPosition);
            setCurrentLocation(newPosition);

            const remainingDistance = getDistance(newPosition, dest);
            console.log("Remaining Distance:", remainingDistance);

            if (remainingDistance <= 50 || progress >= 1) {
                clearInterval(trackingInterval.current);
                setModalVisible(true);
                updateDriverLatLongFunc(rideInfo.id);
                //setStatusMessage(true);
                //setActiveModal('driver_arrived')  
                //setModalData(rideInfo); 
                //checkRideStartStatus();                
            }
        }, 2000);
    };

    const updateDriverLatLongFunc = async (rideId) => {
        console.log("ridestart118: ", rideId);
        const updateDriverLoc = await updateDriverLatLong(rideId);
        console.log("ridestart120:  ", updateDriverLoc);
    }

    const startRideFunc = async (rideId) => {
        try {
            const startRideInfo  = await startRide(rideId);
            console.log("acceptRideInfo=== ", startRideInfo);
            if(startRideInfo){
                //await AsyncStorage.setItem('rideId', rideId.toString());
                navigation.navigate("Ridetrack");    
            }            

        } catch (error) {
            console.error("Error accepting ride:", error);
        }
    };

    return (
        <View style={styles.mainContainer}>
            <Header title="Ride" link="Chooserideparcel" />

            {driverLocation && pickupLocation && (
                <MapView
                    style={styles.map}
                    initialRegion={{
                        latitude: driverLocation.latitude,
                        longitude: driverLocation.longitude,
                        latitudeDelta: 0.05,
                        longitudeDelta: 0.05,
                    }}
                >
                    {/* Animated Driver Marker */}
                   
                    <Marker coordinate={currentLocation} title="Driver Location">
                         <Image source={MAN} style={{ width: 40, height: 40 }} />
                     </Marker>
                    

                    {/* User Pickup Location Marker */}
                    <Marker coordinate={pickupLocation} title="Pickup Location" />

                    {/* Polyline from Driver to Pickup Location */}
                    <MapViewDirections
                        origin={driverLocation}
                        destination={pickupLocation}
                        apikey={GOOGLE_MAPS_API_KEY}
                        strokeWidth={4}
                        strokeColor="blue"
                    />
                </MapView>
            )}

<Modal
                transparent={true}
                visible={modalVisible}
            >
                <View style={styles.modalContainer}>
                    <View style={styles.modalView}>
                        
                        
                        <View style={styles.modalL1View}>
                            <Text style={styles.modalTextBold}>You have arrived at the pickup location</Text>
                                
                            
                        </View>
                        <View style={styles.modalBtnContainer}>
                           
                            <Buttonblack title="Ride Start" wide="40" onPress={() => startRideFunc(rideInfo?.id)} />
                        </View>
                    </View>
                </View>
            </Modal>

        </View>
    );

};

export default Ridestart

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(20),
        justifyContent: "center",
        alignItems: "center"
    },
    modalContainer: {
        flex: 1,
        justifyContent: "flex-end",
        margin: 0
    },
    modalView: {
        backgroundColor: "#FFFFFF",
        borderTopEndRadius: 20,
        borderTopLeftRadius: 20,
        width: wp(95),
        height: hp(40),
        alignSelf: "center",
        paddingTop: 10
    },
    modalL1View: {
        backgroundColor: "#FFFFFF",
        flexDirection: "row",
        justifyContent: "space-between",
        width: wp(90),
        //height: hp(25),
        margin: 10
    },
    modalL2View: {
        backgroundColor: "#FFFFFF",
        //width: wp(90),
        //alignSelf: "center",
        flexDirection: "row",
        justifyContent: "space-between"
    },
    modalTextBold: {
        fontSize: fp(2),
        fontWeight: "bold",
        color: "#000000"
    },
    modalText: {
        fontSize: fp(2),
        color: "#000000"
        
    },
    modalBtnContainer: {
        backgroundColor: "#FFFFFF",
        width: wp(90),
        alignSelf: "center",
        flexDirection: "row",
        justifyContent: "space-around",
        alignItems: "center"
    },
    starContainer: {
        width: wp(30),
        flexDirection: "row",
        justifyContent: "space-evenly"
    },
    greyline: {
        backgroundColor: "lightgrey",
        color: "lightgrey",
        alignSelf: "center",
        width: wp(30),
        height: hp(0.7),
        //paddingTop: 10
    },
    modalFeedbackContainer: {
        flex: 1,
        justifyContent: "flex-end",
        margin: 0
    },
    modalFeedbackView: {
        backgroundColor: "#FFFFFF",
        borderRadius: 20,
        width: wp(95),
        height: hp(55),
        alignItems: "center",
        alignSelf: "center",
        paddingTop: 10
    },
    textSmall: {
        color: "#000000",
    },
    map: {
        flex: 1,
    }
})