import { StyleSheet, Text, View, Image, TouchableOpacity } from 'react-native'
import React, { useState } from 'react'
import { fp, hp, wp } from '../../helpers/Dimensions'
import { useNavigation } from '@react-navigation/native'
import Header from '../../components/Header'
import Textbox from '../../components/Textbox'
import Buttonblack from '../../components/Buttonblack'
import { CARWHITE, LOGO } from '../../assets/Icon'
import Headerback from '../../components/Headerback'
import Toast from 'react-native-simple-toast';

const Verify = (props) => {
    const [otp, setOtp] = useState('1234');
    const navigation = useNavigation();

    const handleOtp = () => {

        //alert("OTP: "+otp);
        console.log("GOHOME");
        const mobile = props.route.params.mobile;

        const apiUrl = 'https://takeme1.greathub.in/taxi/api/verify-otp';

        try {
            var formdata = new FormData();

            formdata.append('otp', otp);
            formdata.append('mobile', mobile);
            var requestOptions = {
                method: 'POST',
                body: formdata,
                redirect: 'follow',
            };
            console.log('formdata', formdata);
            console.log('222Console order request', requestOptions);

            fetch(apiUrl, requestOptions)
                .then(response => response.text())
                .then(result => {
                    console.log('Result order', result);
                    if (JSON.parse(result).status == 1) {
                        Toast.show("Login successfully");
                        navigation.navigate("Dashboard");

                    } else {
                        alert("failure");
                    }
                })
                // this.props.navigation.navigate('OTPScreen')
                .catch(error => {
                    console.log('error', error);
                });
        } catch (error) {
            console.log('error in catch ', error);
        }
    }

    return (
        <View style={styles.mainContainer}>
            <Headerback title="Verify" link="Login" />
            <View style={styles.imgContainer}>
                <Image source={LOGO} />
                <Image source={CARWHITE} />
            </View>
            <View style={styles.labelContainer}>
                <Text style={styles.textH2}>Verify mobile number</Text>
            </View>
            <View style={styles.textBoxContainer}>
                <Textbox title="" wide="80"
                    val={otp}
                    changetext={(e) => setOtp(e)}
                />
            </View>
            <Buttonblack title="Verify" wide="80" onPress={handleOtp} />
            <View style={styles.resendCodeContainter}>
                <Text style={styles.textNormal}>Didn't receive sms?</Text>
                <TouchableOpacity>
                    <Text style={[styles.textNormal, { color: "orange" }]}>Resend Code</Text>
                </TouchableOpacity>
            </View>

        </View>

    )
}

export default Verify

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(60),
        justifyContent: "center",
        alignItems: "center"
    },
    labelContainer: {
        backgroundColor: "#FFFFFF",
        //height: hp(5),
        width: wp(90),
        alignSelf: "center"
    },
    textBoxContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(12),
        width: wp(90),
        alignItems: "center",
        flexDirection: "row",
        justifyContent: "space-evenly",
        alignSelf: "center"
    },
    resendCodeContainter: {
        backgroundColor: "#FFFFFF",
        width: wp(100),
        height: hp(5),
        flexDirection: "row",
        justifyContent: "space-evenly"
    },
    textH2: {
        fontSize: fp(2),
        fontWeight: "bold",
        color: "#000000",
        paddingLeft: 5
    },
    textNormal: {
        fontSize: fp(2),
        color: "#000000"
    },


})