<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Validator;
use App\Models\Discount;

class DiscountController extends Controller
{
	public function index()
  	{
        $data = [];
        $url = url('/');
        $data['TYPE'] = 'admin';
  		return view('admin.discount.index',$data);
	}

    public function index_ajax_discount_list()
    {
        #logged_in();
        $status_array = array(0=>"Idle",1=>"Active",2=>"Delete");
        $recordsTotal = Discount::count_all();
        $data = Discount::get_data_table();
        if($data)
        {
            foreach ($data as $row)
            {
                $row->status_label = isset($status_array[$row->status]) ? $status_array[$row->status] : 'NA';
            }
        }
        $output = array(
                'status'=>1,
                'message'=>'success',
                "recordsTotal" => $recordsTotal,
                "recordsFiltered" => $recordsTotal,
                "data" => $data,
                );

        return Response::json($output, 200);
    }

    public function save(Request $request)
    {
        $customMessages = [
            'name' => 'My Name is Required',
        ];

        $id = $request->id;
        $validator = Validator::make($request->all(),[
            'name' => 'required',
        ], $customMessages);

        if($validator->fails())
              return $this->setValidatorError($validator,1);

        if($request->id){
            $data =  Discount::find($request->id);
        }else{
            $data = new Discount;
        }
        $data->name = $request->name;
        $data->code = $request->code;
        $data->type = $request->type;
        $data->amount = $request->amount;
        $data->min_order = $request->min_order;
        $data->date_from = $request->date_from;
        $data->date_to = $request->date_to;
        $data->time_from = $request->time_from;
        $data->time_to = $request->time_to;
        $data->monday = $request->monday;
        $data->tuesday = $request->tuesday;
        $data->wednesday = $request->wednesday;
        $data->thursday = $request->thursday;
        $data->friday = $request->friday;
        $data->saturday = $request->saturday;
        $data->sunday = $request->sunday;
        $data->save();

        if($request->id){
            $msg = 'Updated';
        }else{
            $last_inserted_id = $data->id;
            $msg = 'Inserted';
        }

        return Response::json([
                        'status'  => true,
                        'message' => 'Discount '.$msg.' Successfully',
                        ]);

    }
}
