<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Validator;
use App\Models\Driver;
use App\Models\Location;
use App\Models\Category;

class DriverController extends Controller
{
	public function index()
  	{
        $data = [];
        $url = url('/');
        $location = Location::where('status', '1')->orderBy('name')->get();
        $category = Category::where('status', '1')->orderBy('name')->get();
        $data['TYPE'] = 'admin';
        $data['location'] = $location;
        $data['category'] = $category;
  		return view('admin.driver.index',$data);
	}

    public function index_ajax_driver_list()
    {
        #logged_in();
        $status_array = array(0=>"Pending",1=>"Approved",2=>"Rejected");
        $recordsTotal = Driver::count_all();
        $data = Driver::get_data_table();
        if($data)
        {
            foreach ($data as $row)
            {
                $row->status_label = isset($status_array[$row->status]) ? $status_array[$row->status] : 'NA';
                if($row->profile_photo){
                    $row->profile_img = url('').'/driver/'.$row->profile_photo;
                }
                if($row->adhar){
                    $row->adhar_img = url('').'/driver/'.$row->adhar;
                }
                if($row->driving_licence){
                    $row->driving_licence_img = url('').'/driver/'.$row->driving_licence;
                }
                if($row->registration_certificate){
                    $row->registration_certificate_img = url('').'/driver/'.$row->registration_certificate;
                }
                if($row->vehicle_photo){
                    $vehicle_photo = json_decode($row->vehicle_photo);
                    $photo_array = array();
                    foreach($vehicle_photo as $ph){
                        $photo_array = url('').'/driver/'.$ph;
                    }
                    $row->vehicle_photo = $photo_array;
                }
            }
        }
        $output = array(
                'status'=>1,
                'message'=>'success',
                "recordsTotal" => $recordsTotal,
                "recordsFiltered" => $recordsTotal,
                "data" => $data,
                );

        return Response::json($output, 200);
    }

    public function save(Request $request)
    {
        $customMessages = [
            'name' => 'My Name is Required',
        ];

        $id = $request->id;
        $validator = Validator::make($request->all(),[
            'location' => 'required',
            'category' => 'required',
        ], $customMessages);

        if($validator->fails())
              return $this->setValidatorError($validator,1);

        $path = public_path().'/driver/';
        $vehicle_photo = '';
        $vp_array = array();
        if ($request->hasfile('vehicle_photo')) {
            foreach ($request->file('vehicle_photo') as $file) {
                $file_name = time() . '.' . $file->extension();
                $file->move($path, $file_name);
                $vp_array[] = $file_name;
            }
        }
        if($vp_array){
            $vehicle_photo = json_encode($vp_array);
        }

        $profile_photo = '';
        if($request->hasFile('profile_photo')){
            $file = $request->file('profile_photo');
            $OriginalName = $file->getClientOriginalName();
            $filename = pathinfo($OriginalName, PATHINFO_FILENAME);
            $profile_photo = time() . '_' .$filename. '.' .$file->extension();
            $file->move($path, $profile_photo);
        }
        $adhar = '';
        if($request->hasFile('adhar')){
            $file = $request->file('adhar');
            $OriginalName = $file->getClientOriginalName();
            $filename = pathinfo($OriginalName, PATHINFO_FILENAME);
            $adhar = time() . '_' .$filename. '.' .$file->extension();
            $file->move($path, $adhar);
        }
        $driving_licence = '';
        if($request->hasFile('driving_licence')){
            $file = $request->file('driving_licence');
            $OriginalName = $file->getClientOriginalName();
            $filename = pathinfo($OriginalName, PATHINFO_FILENAME);
            $driving_licence = time() . '_' .$filename. '.' .$file->extension();
            $file->move($path, $driving_licence);
        }
        $registration_certificate = '';
        if($request->hasFile('registration_certificate')){
            $file = $request->file('registration_certificate');
            $OriginalName = $file->getClientOriginalName();
            $filename = pathinfo($OriginalName, PATHINFO_FILENAME);
            $registration_certificate = time() . '_' .$filename. '.' .$file->extension();
            $file->move($path, $registration_certificate);
        }
        if($request->id){
            $data =  Driver::find($request->id);
        }else{
            $data = new Driver;
        }
        $data->fname = $request->fname;
        $data->lname = $request->lname;
        $data->gender = $request->gender;
        $data->email = $request->email;
        $data->mobile = $request->mobile;
        $data->location = $request->location;
        $data->availability = $request->availability;
        $data->status = $request->status;

        $data->category = $request->category;
        $data->model = $request->model;
        $data->brand = $request->brand;
        $data->year_of_manufacture = $request->year_of_manufacture;
        $data->registration_number = $request->registration_number;
        if($profile_photo){
            $data->profile_photo = $profile_photo;
        }
        if($adhar){
            $data->adhar = $adhar;
        }
        if($driving_licence){
            $data->driving_licence = $driving_licence;
        }
        if($registration_certificate){
            $data->registration_certificate = $registration_certificate;
        }
        if($vehicle_photo){
            $data->vehicle_photo = $vehicle_photo;
        }
        $data->save();

        if($request->id){
            $msg = 'Updated';
        }else{
            $last_inserted_id = $data->id;
            $msg = 'Inserted';
        }

        return Response::json([
                        'status'  => true,
                        'message' => 'Driver '.$msg.' Successfully',
                        ]);

    }
}
