<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Validator;
use App\Models\Location;

class LocationController extends Controller
{
	public function index()
  	{
        $data = [];
        $url = url('/');
        $country = country();
        $currency = currency();
        $distance_unit = distance_unit();
        $data['country'] = $country;
        $data['currency'] = $currency;
        $data['distance_unit'] = $distance_unit;
        $data['TYPE'] = 'admin';
  		return view('admin.location.index',$data);
	}

    public function index_ajax_location_list()
    {
        #logged_in();
        $status_array = array(0=>"Idle",1=>"Active",2=>"Delete");
        $country = country();
        $currency = currency();
        $distance_unit = distance_unit();
        $country_array = array();
        if($country){
            foreach($country as $cnt){
                $country_array[$cnt->id] = $cnt->name;
            }
        }
        $currency_array = array();
        if($currency){
            foreach($currency as $cnt){
                $currency[$cnt->id] = $cnt->name;
            }
        }

        $recordsTotal = Location::count_all();
        $data = Location::get_data_table();
        if($data)
        {
            foreach ($data as $row)
            {
                $row->status_label = isset($status_array[$row->status]) ? $status_array[$row->status] : 'NA';
                $row->country_label = isset($country_array[$row->country]) ? $country_array[$row->country] : 'NA';
                $row->currency_label = isset($currency[$row->currency]) ? $currency[$row->currency] : 'NA';
                $row->distance_unit_label = isset($distance_unit[$row->distance_unit]) ? $distance_unit[$row->distance_unit] : 'NA';
            }
        }
        $output = array(
                'status'=>1,
                'message'=>'success',
                "recordsTotal" => $recordsTotal,
                "recordsFiltered" => $recordsTotal,
                "data" => $data,
                );

        return Response::json($output, 200);
    }

    public function save(Request $request)
    {
        $customMessages = [
            'name' => 'My Name is Required',
        ];

        $id = $request->id;
        $validator = Validator::make($request->all(),[
            'name' => 'required',
        ], $customMessages);

        if($validator->fails())
              return $this->setValidatorError($validator,1);

        if($request->id){
            $data =  Location::find($request->id);
        }else{
            $data = new Location;
        }
        $data->name = $request->name;
        $data->zip_code = $request->zip_code;
        $data->country = $request->country;
        $data->currency = $request->currency;
        $data->commission = $request->commission;
        $data->tax = $request->tax;
        $data->distance_unit = $request->distance_unit;
        $data->save();

        if($request->id){
            $msg = 'Updated';
        }else{
            $last_inserted_id = $data->id;
            $msg = 'Inserted';
        }

        return Response::json([
                        'status'  => true,
                        'message' => 'Location '.$msg.' Successfully',
                        ]);

    }
}
