<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Customer;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;
use Tymon\JWTAuth\Facades\JWTAuth;

class AuthController extends Controller
{
    public function sendOtp(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'mobile' => 'required|digits:10',
        ]);

        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()], 422);
        }

        $mobile = $request->mobile;
        $otp = rand(100000, 999999);

        Customer::updateOrCreate(
            ['mobile' => $mobile],
            [
                'otp' => $otp,
                'otp_expires_at' => Carbon::now()->addMinutes(10)
            ]
        );

        $api_data = [];
        $api_data['otp'] = $otp;

        return response()->json([
            'message'   => 'OTP sent successfully. It is valid for 10 minutes.',
            'data'      => $api_data
        ], 200);
    }

    public function verifyOtp(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'mobile' => 'required|digits:10',
            'otp' => 'required|digits:6',
        ]);

        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()], 422);
        }

        $customer = Customer::where('mobile', $request->mobile)
                            ->where('otp', $request->otp)
                            ->where('otp_expires_at', '>', Carbon::now())
                            ->first();

        if (!$customer) {
            return response()->json(['error' => 'Invalid OTP or OTP has expired.'], 400);
        }

        // Generate JWT token
        $token = JWTAuth::fromUser($customer);

        // Clear the used OTP
        $customer->update(['otp' => null, 'otp_expires_at' => null]);

        return response()->json([
            'token' => $token,
            'mobile' => $customer->mobile
        ], 200);
    }
}
