<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Tymon\JWTAuth\Contracts\JWTSubject;

class Customer extends Authenticatable implements JWTSubject
{
    protected $table = 'customer';

    protected $fillable = [
        'mobile',
        'otp',
        'otp_expires_at',
    ];

    /*protected $hidden = [
        'otp', // Hide OTP if not needed in responses
        'otp_expires_at',
    ];*/

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
        return [
            'mobile' => $this->mobile,
        ];
    }       
}
