@extends('admin.layouts.main')
@section('main.container')
<div class="authincation d-flex flex-column flex-lg-row flex-column-fluid">
    <div class="login-aside text-center  d-flex flex-column flex-row-auto">
        <div class="d-flex flex-column-auto flex-column pt-lg-40 pt-15">
            <div class="text-center mb-lg-4 mb-2 pt-5 logo">
                <img src="/assets/images/logo-white.png" class="img-fluid logo">
            </div>
            <h3 class="mb-2 text-white">Welcome to Take Me!</h3>
            <p class="mb-4">Have a better sharing experince</p>
        </div>
        <div class="aside-image position-relative" style="background-image:url(/assets/images/background/pic-2.png);">
            <img class="img1 move-1" src="/assets/images/background/pic3.png" alt="">
            <img class="img2 move-2" src="/assets/images/background/pic4.png" alt="">
            <img class="img3 move-3" src="/assets/images/background/pic5.png" alt="">
        </div>
    </div>
    <div class="container flex-row-fluid d-flex flex-column justify-content-center position-relative overflow-hidden p-7 mx-auto">
        <div class="d-flex justify-content-center h-100 align-items-center">
            <div class="authincation-content style-2">
                <div class="row no-gutters">
                    <div class="col-xl-12 tab-content">
                        <div id="sign-up" class="auth-form tab-pane fade show active  form-validation">
                        <form method="POST" action="/<?= $TYPE ?>/login" id="loginForm" autocomplete="off" class="my-form c-form">
                                <div class="text-center mb-4">
                                    <h3 class="text-center mb-2 text-black">Sign In</h3>
                                </div>
                                <div class="sepertor">
                                    <span class="d-block mb-4 fs-13">with Mobile</span>
                                </div>
                                <div class="mb-3">
                                    <label for="mobile" class="form-label mb-2 fs-13 label-color font-w500">Login</label>
                                    <input type="text" class="form-control numeric" name="mobile" id="mobile" placeholder="Mobile" required>
                                </div>
                                <div class="mb-3">
                                    <label for="password" class="form-label mb-2 fs-13 label-color font-w500">Password</label>
                                    <input type="password" class="form-control" name="password" id="password" placeholder="Password" required>
                                </div>
                                <button type="submit" class="btn btn-block btn-primary">Sign In</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
$(document).ready(function() {
    $("#loginForm").on('submit', function(e) {
        e.preventDefault();
        var loginForm = $(this).serializeArray();
        loginForm.push({name: 'api', value: 1});
        loginForm.push({name: 'action', value: 'login'});
        $.ajax({
            url: $(this).attr('action'),
            type: 'post',
            data: loginForm,
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            success: function(response){
                if(response.status == '1') {
                    window.location.href = '/<?= $TYPE ?>/dashboard';
                }else{
                    $.notify(response.message, {type: 'warning',align:"center", verticalAlign:"top", close: true});
                }
            }
        });
    });
});
</script>
@endsection
