import React, { useEffect, useState } from 'react';
import {View,Text,FlatList,Image,StyleSheet} from 'react-native';
import { useNavigation } from '@react-navigation/native';
import { fp, hp, wp } from '../helpers/Dimensions'
import { DROPICON, PICKICON, STAR } from '../assets/Icon'
import Buttonwhite from '../components/Buttonwhite';
import Buttonblack from '../components/Buttonblack';
import { acceptRide, rejectRide } from '../services/RideService';

const InitiateRides = ({ rides: propRides }) => {
    const navigation = useNavigation();
    const [rides, setRides] = useState([]);
    const [modalVisible, setModalVisible] = useState(true);

    useEffect(() => {
        setRides(propRides);
      }, [propRides]);


    const handleDecline = async (rideId) => {
        const rejectRideResponse = await rejectRide(rideId);
        setRides(prev => prev.filter(ride => ride.id !== rideId));
    }

    const acceptRideFunc = async (rideId, is_schedule=0, is_queued=0) => {
        try {
            const acceptRideInfo  = await acceptRide(rideId, 0, is_queued);
            
            if(acceptRideInfo){
                
                if(acceptRideInfo?.status_name == 'SCHEDULE_RIDE'){
                    navigation.navigate("Dashboard");            
                } else if(acceptRideInfo?.status_name == 'QUEUED'){
                  setModalVisible(false);
                } else {
                    navigation.navigate("Ridestart");    
                }
            }            

        } catch (error) {
            console.error("Error accepting ride:", error);
        }
    };

  const renderItem = ({ item, index }) => {
    const backgroundColor = index % 2 === 0 ? '#f9f9f9' : '#ffffff';
    return (
    <View style={[styles.requestContainer, { backgroundColor }]}>
      {/* Rider Info */}
      <View style={styles.requestView}>
        <View style={{ backgroundColor: "#FFFFFF", width: wp(20) }}>
          <Image
            source={{ uri: item.user.photo_url }}
            style={styles.profileImage}
          />
        </View>
        <View style={{ width: wp(50) }}>
          <Text style={styles.txtNormalBold}>{item.user.name}</Text>
          <Text style={styles.txtNormal}>
            {item.currency_icon} {item.final_price || '—'}
          </Text>
        </View>
        <View style={{ width: wp(20) }} />
      </View>

      {/* Pickup Info */}
      <View style={styles.requestView}>
        <View style={styles.locationView}>
          <View style={{ width: wp(20), paddingLeft: 20 }}>
            <Image source={PICKICON} />
          </View>
          <View style={{ width: wp(50) }}>
            <Text style={styles.txtNormalBold}>{item.pickup_address}</Text>
          </View>
        </View>
      </View>

      {/* Dropoff Info */}
      <View style={styles.requestView}>
        <View style={styles.locationView}>
          <View style={{ width: wp(20), paddingLeft: 20 }}>
            <Image source={DROPICON} />
          </View>
          <View style={{ width: wp(50) }}>
            <Text style={styles.txtNormalBold}>{item.delivery_address}</Text>
          </View>
        </View>
      </View>

      {item?.schedule_ride != null && (
          <Buttonblack
          title={`Schedule: ${item.schedule_ride}`}
          wide="70"
          />
      )}

      {/* Buttons */}
      <View style={styles.buttonContainer}>
        <Buttonwhite
          title="Decline"
          wide="40"
          onPress={() => handleDecline(item.id)}
        />
        <Buttonblack
          title="Accept"
          wide="40"
          onPress={() => acceptRideFunc(item?.id, item?.schedule_ride, item?.queued)}
        />
      </View>
    </View>
  );
};

  return (
    <FlatList
      data={rides}
      keyExtractor={(item) => item.id.toString()}
      renderItem={renderItem}
      contentContainerStyle={{ paddingBottom: 100 }}
    />
  );

};

export default InitiateRides;

const styles = StyleSheet.create({
    mainContainer: {
        width: wp(100),
        height: hp(100)
    },
    contentContainer: {
        backgroundColor: "#F5F5F5",
        width: wp(100),
        height: hp(78)
    },
    statusContainer: {
        backgroundColor: "#FFFFFF",
        width: wp(95),
        height: hp(8),
        flexDirection: "row",
        alignSelf: "center",
        alignItems: "center",
        justifyContent: "space-between",
        borderRadius: 20,        
        padding: 20,
        margin: 7
    },
    statsContainer: {
        backgroundColor: "#FFFFFF",
        width: wp(95),
        height: hp(22),
        alignSelf: "center",
        alignItems: "center",
        justifyContent: "space-between",
        borderRadius: 20,
        padding: 20,
        margin: 7
    },    
    rideRatingContainer: {
        flexDirection: "row",
        width: wp(80),
        alignSelf: "center",
        justifyContent: "space-between"
    },
    conContainer: {
        //width: wp(80),
        height: hp(7),
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "space-between",
        borderRadius: 10,
        borderColor: "#FFC727",
        borderWidth: 1,
        padding: 7,
        //margin: 7
    },
    requestContainer: {
        backgroundColor: "#FFFFFF",
        width: wp(95),
        height: hp(38),
        borderRadius: 20,
        alignSelf: "center",
        paddingTop: 10
    },
    requestView: {
        backgroundColor: "#FFFFFF",
        flexDirection: "row",
        justifyContent: "space-between",
        width: wp(90),
        //height: hp(25),
        margin: 10
    },
    locationView: {
        backgroundColor: "#FFFFFF",
        //width: wp(90),
        //alignSelf: "center",
        flexDirection: "row",
        justifyContent: "space-between"
    },
    buttonContainer: {
        backgroundColor: "#FFFFFF",
        width: wp(90),
        alignSelf: "center",
        flexDirection: "row",
        justifyContent: "space-around",
        alignItems: "center"
    },
    starContainer: {
        width: wp(30),
        flexDirection: "row",
        justifyContent: "space-evenly"
    },
    txtSmall: {
        color: "#000000",
        fontSize: fp(1.5),
    },
    txtSmallBold: {
        color: "#000000",
        fontSize: fp(1.5),
        fontWeight: "bold"
    },    
    txtNormal: {
        color: "#000000",
        fontSize: fp(2),
    },
    txtNormalBold: {
        color: "#000000",
        fontSize: fp(2),
        fontWeight: "bold"
    },
    txtLarge: {
        color: "#000000",
        fontSize: fp(2.2),
    },
    txtLargeBold: {
        color: "#000000",
        fontSize: fp(2.2),
        fontWeight: "bold"
    },
    profileImage: {
        width: wp(10),
        height: hp(5),
        borderRadius: 25,
      },
})
