import { StyleSheet, Text, View, Image } from 'react-native'
import React, { useEffect, useState } from 'react'
import { fp, hp, wp } from '../../helpers/Dimensions'
import { Dropdown } from 'react-native-element-dropdown';
import Header from '../../components/Header';
import { LOGO } from '../../assets/Icon';
import Buttonblack from '../../components/Buttonblack';
import { useNavigation } from '@react-navigation/native';
import { cancelReasonList, cancelRide } from '../../services/RideService';



const Cancelride = ({ route, navigation }) => {
    const [reasons, setReasons] = useState([]);
    const [selectedReason, setSelectedReason] = useState(null);
    const [isFocus, setIsFocus] = useState(false);
    const [value, setValue] = useState(null)

    useEffect(() => {
        fetchCancelReasons();
      }, []);

    const fetchCancelReasons = async () => {
        try {
          const response = await cancelReasonList();
          setReasons(response);
        } catch (error) {
          console.error("Error fetching cancel reasons:", error);
        }
      };

      const reideCancel = async () => {
        try {
            const { ride_id } = route.params;
            const result = await cancelRide({parcel_id: ride_id, reason: selectedReason.id});
            console.log("cancelride33====== ", result);
            if(result){
                navigation.navigate('Dashboard');    
            }

        } catch (error) {
          console.error("Cancel error:", error);
        }
      };

    return (
        <View style={styles.mainContainer}>
            <Header title="Cancel Ride" link="Documents" />
            <View style={styles.imgContainer}>
                <Image source={LOGO} />
            </View>
            <View style={styles.textContainer}>
                <Text style={styles.textH3}>Please select reason for cancelling the ride</Text>
            </View>
            <View style={styles.dropDownContainer}>
                <Dropdown
            style={styles.dropdown}
            data={reasons}
            labelField="reason"
            valueField="id"
            placeholder="Select Reason"
            value={selectedReason?.id} 
            onFocus={() => setIsFocus(true)}
            onChange={item => {
                setSelectedReason(item); 
                setIsFocus(false);
            }}
        />
            </View>
            <Buttonblack title="Done" wide="90" onPress={() => reideCancel()}/>
        </View>
    )
}

export default Cancelride

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(20),
        justifyContent: "center",
        alignItems: "center"
    },
    textContainer: {
        backgroundColor: "#FFFFFF",
        width: wp(70),
        alignSelf: "center",
        margin: 10
    },
    dropDownContainer: {
        backgroundColor: "#FFFFFF",
        width: wp(80),
        height: hp(50),
        alignSelf: "center"
    },
    textH3: {
        fontSize: fp(2.5),
        fontWeight: "bold",
        color: "#000000",
        //paddingLeft: 5
    },
    textNormal: {
        fontSize: fp(1.5),
        color: "#000000"
    },
    dropdown: {
        height: 50,
        borderColor: '#223138',
        borderWidth: 2,
        borderRadius: 8,
        paddingHorizontal: 8,
    },

})