import { StyleSheet, Text, View, Image, Modal } from 'react-native'
import React, { useState } from 'react'
import Header from '../../components/Header'
import { fp, hp, wp } from '../../helpers/Dimensions'
import { CIRCLE, DROPICON, LOGO, MAN, MAP, OFFLINE, ONLINE, PICKICON, PIPEICON, STAR, STARWHITE } from '../../assets/Icon'
import Buttonblack from '../../components/Buttonblack'
import Buttonwhite from '../../components/Buttonwhite'
import Textarea from '../../components/Textarea'


const Location = () => {
    const { modalVisible, setModalVisible } = useState(false);
    const { modal2Visible, setModal2Visible } = useState(true);
    const { modal3Visible, setModal3Visible } = useState(false);

    return (
        <View style={styles.mainContainer}>
            <Header title="Feedback" link="Documents" />
            <View style={styles.imgContainer}>
                <Image source={ONLINE} />
            </View>
            <View style={styles.mapContainer}>
                <Image source={MAP} />
            </View>
            <Text>Location</Text>

            <Modal
                transparent={true}
                visible={modalVisible}
            >
                <View style={styles.modalContainer}>
                    <View style={styles.modalView}>
                        <View style={styles.greyline}></View>
                        <View style={styles.modalL1View}>
                            <View style={{ backgroundColor: "#FFFFFF", width: wp(20) }}>
                                <Image source={MAN} />
                            </View>
                            <View style={{ width: wp(50) }}>
                                <Text style={styles.modalTextBold}>George Jacob</Text>
                                <View style={[styles.starContainer, { width: wp(20) }]}>
                                    <Image source={STAR} />
                                    <Image source={STAR} />
                                    <Image source={STAR} />
                                    <Image source={STAR} />
                                    <Image source={STAR} />
                                </View>
                                <Text>USD 6 - USD 9</Text>
                                <View style={styles.modalL2View}>
                                    <View style={{ width: wp(10) }}>
                                        <Image source={PICKICON} />
                                    </View>
                                    <View style={{ width: wp(50) }}>
                                        <Text style={styles.textNormal}>Douglas Crecent Road</Text>
                                        <Text style={styles.textSmall}>5 min (1.8 mi) away</Text>
                                    </View>
                                </View>
                                <View style={styles.modalL2View}>
                                    <Image source={PIPEICON} />
                                </View>
                                <View style={styles.modalL2View}>
                                    <View style={{ width: wp(10) }}>
                                        <Image source={DROPICON} />
                                    </View>
                                    <View style={{ width: wp(50) }}>
                                        <Text style={styles.textNormal}>Douglas Crecent Road</Text>
                                        <Text style={styles.textSmall}>5 min (1.8 mi) away</Text>
                                    </View>
                                </View>
                            </View>
                            <View style={{ width: wp(20) }}></View>

                        </View>
                        <View style={styles.modalBtnContainer}>
                            <Buttonwhite title="Decline" wide="40" />
                            <Buttonblack title="Accept" wide="40" />

                        </View>
                    </View>
                </View>
            </Modal>
            {/* MODAL 2 */}
            <Modal
                transparent={true}
                visible={false}
            >
                <View style={styles.modalContainer}>
                    <View style={styles.modalView}>
                        <View style={styles.greyline}></View>
                        <View style={styles.modalL1View}>
                            <View style={{ backgroundColor: "#FFFFFF", width: wp(20) }}>
                                <Image source={MAN} />
                            </View>
                            <View style={{ width: wp(50) }}>
                                <Text style={styles.modalTextBold}>George Jacob</Text>
                                <View style={[styles.starContainer, { width: wp(20) }]}>
                                    <Image source={STAR} />
                                    <Image source={STAR} />
                                    <Image source={STAR} />
                                    <Image source={STAR} />
                                    <Image source={STAR} />
                                </View>
                                <Text>USD 6 - USD 9</Text>
                                <View style={styles.modalL2View}>
                                    <View style={{ width: wp(10) }}>
                                        <Image source={PICKICON} />
                                    </View>
                                    <View style={{ width: wp(50) }}>
                                        <Text style={styles.textNormal}>Douglas Crecent Road</Text>
                                        <Text style={styles.textSmall}>5 min (1.8 mi) away</Text>
                                    </View>
                                </View>
                                <View style={styles.modalL2View}>
                                    <Image source={PIPEICON} />
                                </View>
                                <View style={styles.modalL2View}>
                                    <View style={{ width: wp(10) }}>
                                        <Image source={DROPICON} />
                                    </View>
                                    <View style={{ width: wp(50) }}>
                                        <Text style={styles.textNormal}>Douglas Crecent Road</Text>
                                        <Text style={styles.textSmall}>5 min (1.8 mi) away</Text>
                                    </View>
                                </View>
                            </View>
                            <View style={{ width: wp(20) }}></View>

                        </View>
                        <Buttonblack title="End Ride" wide="90" />
                    </View>
                </View>
            </Modal>
            {/* MODAL 3 */}
            <Modal
                transparent={true}
                visible={true}
            >
                <View style={styles.modalFeedbackContainer}>
                    <View style={styles.modalFeedbackView}>
                        <Image source={MAN} />
                        <Text style={styles.modalTextBold}>Geaoge Jacon</Text>
                        <View style={styles.starContainer}>
                            <Image source={STAR} style={{ height: hp(2.5), width: wp(2.5) }} />
                            <Image source={STAR} style={{ height: hp(2.5), width: wp(2.5) }} />
                            <Image source={STAR} style={{ height: hp(2.5), width: wp(2.5) }} />
                            <Image source={STAR} style={{ height: hp(2.5), width: wp(2.5) }} />
                            <Image source={STAR} style={{ height: hp(2.5), width: wp(2.5) }} />
                        </View>
                        <View style={{ height: hp(10) }}>
                            <Text style={styles.textH2}>How was your trip?</Text>
                        </View>

                        <View style={{ borderRadius: 10, backgroundColor: "#000000", height: hp(10), width: wp(90), alignItems: "center" }}>
                            <Text style={styles.textH3}>How was your trip?</Text>
                            <View style={[styles.starContainer, { width: wp(50) }]}>
                                <Image source={STARWHITE} />
                                <Image source={STARWHITE} />
                                <Image source={STARWHITE} />
                                <Image source={STARWHITE} />
                                <Image source={STARWHITE} />
                            </View>
                        </View>
                        <Textarea title="Comment" wide="90" />
                        <Buttonblack title="Send" wide="90" />
                        <View style={{ height: hp(8) }}></View>
                        <View style={styles.greyline}></View>
                    </View>
                </View>
            </Modal>
        </View>

    )
}

export default Location

const styles = StyleSheet.create({

    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(10),
        justifyContent: "center",
        alignItems: "center"
    },
    mapContainer: {
        backgroundColor: "red",
        width: wp(100),
        alignSelf: "center"
    },
    textH3: {
        fontSize: fp(2.5),
        fontWeight: "bold",
        color: "#FFFFFF",
        //paddingLeft: 5
    },
    textH2: {
        fontSize: fp(2),
        fontWeight: "bold",
        color: "#000000",
        //paddingLeft: 5
    },
    textNormal: {
        fontSize: fp(1.5),
        color: "#000000"
    },
    textSmall: {
        fontSize: fp(1.2),
        color: "#000000"
    },
    modalContainer: {
        flex: 1,
        justifyContent: "flex-end",
        margin: 0
    },
    modalView: {
        backgroundColor: "#FFFFFF",
        borderRadius: 20,
        width: wp(95),
        height: hp(35),
        alignSelf: "center",
        paddingTop: 10
    },
    modalL1View: {
        backgroundColor: "#FFFFFF",
        flexDirection: "row",
        justifyContent: "space-between",
        width: wp(90),
        //height: hp(25),
        margin: 20
    },
    modalL2View: {
        backgroundColor: "#FFFFFF",
        //width: wp(90),
        //alignSelf: "center",
        flexDirection: "row",
        justifyContent: "space-between"
    },
    modalTextBold: {
        fontSize: fp(2),
        fontWeight: "bold"
    },
    modalText: {
        fontSize: fp(2)
    },
    modalBtnContainer: {
        backgroundColor: "#FFFFFF",
        width: wp(90),
        alignSelf: "center",
        flexDirection: "row",
        justifyContent: "space-around",
        alignItems: "center"
    },
    starContainer: {
        width: wp(30),
        flexDirection: "row",
        justifyContent: "space-evenly"
    },
    greyline: {
        backgroundColor: "lightgrey",
        color: "lightgrey",
        alignSelf: "center",
        width: wp(30),
        height: hp(0.7),
        //paddingTop: 10
    },
    modalFeedbackContainer: {
        flex: 1,
        justifyContent: "flex-end",
        margin: 0
    },
    modalFeedbackView: {
        backgroundColor: "#FFFFFF",
        borderRadius: 20,
        width: wp(95),
        height: hp(55),
        alignItems: "center",
        alignSelf: "center",
        paddingTop: 10
    },

})