import { StyleSheet, Text, View, Image } from 'react-native'
import React from 'react'
import { fp, hp, wp } from '../../helpers/Dimensions'
import { LOGO } from '../../assets/Icon'
import Header from '../../components/Header'
import Buttonblack from '../../components/Buttonblack'
import { useNavigation } from '@react-navigation/native'

const Registrationcertificate = () => {
    const navigation = useNavigation()

    return (
        <View style={styles.mainContainer}>
            <Header title="Registration Certificate (RC)" link="Documents" />
            <View style={styles.imgContainer}>
                <Image source={LOGO} />
            </View>
            <View style={styles.textContainer}>
                <Text style={styles.textH2}>Upload your registration certificate (RC)</Text>
                <Text style={[styles.textNormal, { paddingTop: 10 }]}>Make sure photo is not blurred and clearly visible.</Text>
            </View>
            <View style={styles.photoContainer}>
                <View style={styles.photoArea}>
                </View>

            </View>
            <Buttonblack title="Upload Photo" wide="90" />
            <Buttonblack title="Next" wide="90" onPress={() => navigation.navigate("Inspectionpoints")} />
        </View>

    )
}

export default Registrationcertificate

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(20),
        justifyContent: "center",
        alignItems: "center"
    },
    textContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(15),
        width: wp(90),
        alignSelf: "center",
        paddingTop: 20
    },
    photoContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(30),
        //width: wp(100),
        justifyContent: "center",
        alignItems: "center"
    },
    photoArea: {
        backgroundColor: "lightgrey",
        textAlign: "center",
        borderRadius: 10,
        height: hp(25),
        width: wp(80)
    },
    textH2: {
        fontSize: fp(2.5),
        fontWeight: "bold",
        color: "#000000",
        //paddingLeft: 5
    },
    textNormal: {
        fontSize: fp(2),
        color: "#000000"
    },

})