import { StyleSheet, Text, View } from 'react-native'
import React from 'react'
import { fp, hp, wp } from '../../helpers/Dimensions'
import { LOGO } from '../../assets/Icon'
import Header from '../../components/Header'
import Buttonblack from '../../components/Buttonblack'
import { useNavigation } from '@react-navigation/native'


const Vehicleinsurance = () => {
    const navigation = useNavigation()

    return (
        <View style={styles.mainContainer}>
            <Header title="Vehicle Insurance" link="Documents" />
            <View style={styles.textContainer}>
                <Text style={styles.textH2}>Take PHoto of your Vehicle insurance</Text>
                <Text style={[styles.textNormal, { paddingTop: 10 }]}>Make sure photo is not blurred and these details are clearly visible - Model nnumber, Expiry date,
                    Chasis number, Registration number, start date, financier name or company name. You may need to submit multiple photos if your
                    document have multiple pages or sides or if page was not clear.</Text>
            </View>
            <View style={styles.photoContainer}>
                <View style={styles.photoArea}>
                </View>

            </View>
            <Buttonblack title="Upload Photo" wide="90" />
            <Buttonblack title="Next" wide="90" onPress={() => navigation.navigate("Registrationcertificate")} />
        </View>

    )
}

export default Vehicleinsurance

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(20),
        justifyContent: "center",
        alignItems: "center"
    },
    textContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(25),
        width: wp(90),
        alignSelf: "center",
        paddingTop: 20
    },
    photoContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(45),
        //width: wp(100),
        justifyContent: "center",
        alignItems: "center"
    },
    photoArea: {
        backgroundColor: "lightgrey",
        textAlign: "center",
        borderRadius: 10,
        height: hp(40),
        width: wp(80)
    },
    textH2: {
        fontSize: fp(2.5),
        fontWeight: "bold",
        color: "#000000",
        //paddingLeft: 5
    },
    textNormal: {
        fontSize: fp(2),
        color: "#000000"
    },


})