import { Button, PermissionsAndroid, StyleSheet, Text, Touchable, TouchableOpacity, View } from 'react-native'
import React, { useEffect, useState } from 'react'
import { useNavigation } from '@react-navigation/native'
import MapView, { Marker, Polyline } from 'react-native-maps';
import Geolocation from 'react-native-geolocation-service';
import MapViewDirections from 'react-native-maps-directions';

const GOOGLE_MAPS_APIKEY = "AIzaSyDZDczEIV69u0OyAG0B7FtJwQiTc5TzGj0";
const OnlyMap = () => {
    const [mLat, setMLat] = useState(0);
    const [mLong, setMLong] = useState(0);

    const source = { latitude: 28.644076, longitude: 77.408259 };
  const destination = { latitude: 28.628452, longitude: 77.377002 };

    const navigation = useNavigation();
    useEffect(() => {
        requestCameraPermission();
    }, [])

    const requestCameraPermission = async () => {
        try {
          const granted = await PermissionsAndroid.request(
            PermissionsAndroid.PERMISSIONS.ACCESS_FINE_LOCATION,
            {
              title: 'Cool Photo App Location Permission',
              message:
                'Cool Photo App needs access to your camera ' +
                'so you can take awesome pictures.',
              buttonNeutral: 'Ask Me Later',
              buttonNegative: 'Cancel',
              buttonPositive: 'OK',
            },
          );
          if (granted === PermissionsAndroid.RESULTS.GRANTED) {
            console.log('You can use the location');
          } else {
            console.log('Location permission denied');
          }
        } catch (err) {
          console.warn(err);
        }
      };
    
      const getLocation = () => {
        Geolocation.getCurrentPosition(
          (position) => {
            console.log(position);
            setMLat(position.coords.latitude);
            setMLong(position.coords.longitude);
          },
          (error) => {
            // See error code charts below.
            console.log(error.code, error.message);
          },
          { enableHighAccuracy: true, timeout: 15000, maximumAge: 10000 }
      );
      }
  return (
    <View style={{ flex: 1 }}>
      <MapView
        provider="google"
        style={{ flex: 1 }}
        initialRegion={{
          latitude: 28.628224,
          longitude: 77.374995,
          latitudeDelta: 0.3,
          longitudeDelta: 0.3,
        }}
        onRegionChange={x =>{
            console.log('changecoord', x)
        }}>
        <Marker coordinate={{latitude: 28.5096313, longitude: 77.3238112}} />

        <Marker coordinate={source} title="Pickup Location" pinColor="green" />

        <Marker coordinate={destination} title="Drop-off Location" pinColor="red" />

        <MapViewDirections
        origin={source}
        destination={destination}
        apikey={GOOGLE_MAPS_APIKEY}
        strokeWidth={5}
        strokeColor="blue"
      />
      </MapView>
      

      <TouchableOpacity style={{width: '90%', height: 50, alignSelf: 'center', position: 'absolute', backgroundColor: 'orange', justifyContent: 'center', alignItems: 'center'}} onPress={()=>{
        getLocation();
      }}>

        <Text style={{color: '#fff'}}> Current Location</Text>
        <Button title="Current Rides" onPress={() => navigation.navigate("CurrentRides")}/>
      </TouchableOpacity>
    </View>
  
  )
}

export default OnlyMap

const styles = StyleSheet.create({})