import { apiRequest } from "./ApiService";

export const getRecentRide = async () => {
    return await apiRequest("ride-latest", "GET");
};

export const initiateRides = async (args) => {
    return await apiRequest("ride-pending", "POST", args);
};

export const acceptRide = async (rideId, isSchedule=0, isQueued=0) => {
    return await apiRequest('ride-accept','POST', {parcel_id: rideId, is_schedule: isSchedule,is_queued:isQueued });
}

export const rejectRide = async (rideId) => {
    return await apiRequest('ride-reject','POST', {parcel_id: rideId});
}

export const getAfterAcceptRide = async (rideId) => {
    return await apiRequest('ride-after-accept','POST', {parcel_id: rideId});
}

export const getInProcessRide = async () => {
    return await apiRequest("ride-inprocess", "GET");
};

export const driverOnTheWay = async (rideId) => {
    return await apiRequest("driver-on-the-way", "POST", {parcel_id: rideId});
};

export const updateDriverLatLong = async (rideId) => {
    return await apiRequest("ride-arrived-pickup-loc", "POST", {parcel_id: rideId});
};

export const otpVerify = async (rideId, otp) => {
    return await apiRequest("otp-verify", "POST", {parcel_id: rideId, otp:otp});
};

export const startRide = async (rideId) => {
    return await apiRequest('ride-start','POST', {parcel_id: rideId});
}

export const trackRide = async (rideId) => {
    return await apiRequest('ride-track','POST', {parcel_id: rideId});
}

export const ridePaymentInitiated = async (rideId) => {
    return await apiRequest('ride-payment-initiated','POST', {parcel_id: rideId});
}

export const ridePaymentInitiatedFare = async (rideId) => {
    return await apiRequest('ride-payment-initiate-fare','POST', {parcel_id: rideId});
}

export const rideSummary = async (rideId) => {
    return await apiRequest('ride-summary','POST', {parcel_id: rideId});
}

export const feedback = async (args) => {
    return await apiRequest('feedback','POST', args);
}

export const completeRide = async (rideId) => {
    return await apiRequest('ride-deliver','POST', {parcel_id: rideId});
}

export const cancelReasonList = async (args) => {
    return await apiRequest('cancel-reason');
}

export const cancelRide = async (args) => {
    return await apiRequest('ride-cancel', 'POST', args);
}



