import { Image, Modal, StyleSheet, Text, TouchableOpacity, View } from 'react-native'
import React, { useState } from 'react'
import { fp, hp, wp } from '../helpers/Dimensions'
import { ACCOUNTICON, HOMEICON, ORDERICON } from '../assets/Icon'
import { useNavigation } from '@react-navigation/native'

const Footer = () => {
    const [modalVisible, setModalVisible] = useState(false);

    const navigation = useNavigation() 

    return (
        <View style={styles.mainContainer}>
            <View style={styles.footerContainer}>
                <TouchableOpacity onPress={() => navigation.navigate("Dashboard")}>
                <View style={styles.footerBlockContainer}>
                    <Image source={HOMEICON} />
                    <Text style={styles.txtNormal}>Home</Text>
                </View>
                </TouchableOpacity>
                <TouchableOpacity onPress={() => navigation.navigate("Myrides")}>
                <View style={styles.footerBlockContainer}>
                    <Image source={ORDERICON} />
                    <Text style={styles.txtNormal}>Orders</Text>
                </View>
                </TouchableOpacity>
                <TouchableOpacity onPress={() => navigation.navigate("Profile")}>
                <View style={styles.footerBlockContainer}>
                    <Image source={ACCOUNTICON} />
                    <Text style={styles.txtNormal}>Account</Text>
                </View>
                </TouchableOpacity>
            </View>           
        </View>
    )
}

export default Footer

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#D8E2E7",
        width: wp(100),
        //height: hp(100)
    },
    footerContainer: {
        backgroundColor: "#000000",
        width: wp(100),
        height: hp(10),
        borderWidth: 1,
        borderColor: "#CCCCCC",
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "space-evenly"
    },
    footerBlockContainer: {
        alignItems: "center"
    },
    modalContainer: {
        flex: 1,
        justifyContent: 'flex-end', // Align to bottom
        backgroundColor: "#FFFFF",
        marginBottom: 20
    },
    modalContent: {
        backgroundColor: '#000000',
        padding: 20,
        //borderTopLeftRadius: 20,
        //borderTopRightRadius: 20,
        elevation: 5,
        marginBottom: 75
    },
    modallistContainer: {
        backgroundColor: "#000000",
        width: wp(90),
        flexDirection: "row",
        alignSelf: "center",
        alignItems: "center",
        justifyContent: "space-between"
    },
    sepratorLine: {
        backgroundColor: "#CCCCCC",
        width: wp(90),
        height: hp(0.2),
        alignSelf: "center",
        margin: 20
    },    
    txtNormal: {
        color: "#FFFFFF",
        fontSize: fp(1.5),
    },  
    txtNormalWhite: {
        fontSize: fp(2),
        color: "#FFFFFF"
    },      

})