import { StyleSheet, Text, View, Image } from 'react-native'
import React from 'react'
import { DL, LOGO } from '../../assets/Icon'
import Header from '../../components/Header'
import { fp, hp, wp } from '../../helpers/Dimensions'
import Buttonblack from '../../components/Buttonblack'
import { useNavigation } from '@react-navigation/native'

const Drivinglicence = () => {
    const navigation = useNavigation()

    return (
        <View style={styles.mainContainer}>
            <Header title="Driving Licence" link="Documents" />
            <View style={styles.photoContainer}>
                <View style={styles.photoArea}>
                    <Image source={DL} style={{ borderRadius: 15, height: hp(20), width: wp(80) }} />
                </View>

            </View>
            <View style={styles.buttonContainer}>
                <Buttonblack title="Take Photo" wide="40" />
                <Buttonblack title="Upload Photo" wide="40" />
            </View>
            <View style={styles.photoContainer}>
                <View style={styles.photoArea}>
                    <Image source={DL} style={{ borderRadius: 15, height: hp(20), width: wp(80) }} />
                </View>

            </View>
            <View style={styles.buttonContainer}>
                <Buttonblack title="Take Photo" wide="40" />
                <Buttonblack title="Upload Photo" wide="40" />
            </View>
            <Buttonblack title="Next" wide="90" onPress={() => navigation.navigate("Vehicleinsurance")} />
        </View>

    )
}

export default Drivinglicence

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(20),
        justifyContent: "center",
        alignItems: "center"
    },
    photoContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(30),
        //width: wp(100),
        justifyContent: "center",
        alignItems: "center"
    },
    photoArea: {
        backgroundColor: "lightgrey",
        textAlign: "center",
        borderRadius: 10,
        height: hp(20),
        width: wp(80)
    },
    buttonContainer: {
        //backgroundColor: "red",
        width: wp(90),
        alignSelf: "center",
        flexDirection: "row",
        justifyContent: "space-around",
        alignItems: "center"
    },
    textH3: {
        fontSize: fp(3),
        fontWeight: "bold",
        color: "#000000",
        //paddingLeft: 5
    },
    textNormal: {
        fontSize: fp(1.5),
        color: "#000000"
    },


})