import { StyleSheet, Text, View, Image } from 'react-native'
import React from 'react'
import { fp, hp, wp } from '../../helpers/Dimensions'
import Header from '../../components/Header'
import Buttonblack from '../../components/Buttonblack'
import Textarea from '../../components/Textarea'
import { INCIDENT, INCIDENTCAR, LOGO, MINI, STAR } from '../../assets/Icon'

const Incident = () => {
    return (
        <View style={styles.mainContainer}>
            <Header title="Incident" link="Documents" />
            <View style={styles.imgContainer}>
                <Image source={LOGO} />
            </View>            
            <View style={styles.photoContainer}>
                <View style={styles.viewContainer}>
                    <Image source={INCIDENTCAR} />
                    <Image source={INCIDENTCAR} />
                </View>
                <View style={{height:hp(2)}}></View>
                <View style={styles.viewContainer}>
                    <Image source={INCIDENTCAR} />
                    <Image source={INCIDENTCAR} />
                </View>

                <Buttonblack title="Upload Photos" wide="70" />
            </View>
            <View style={styles.msgContainer}>
                <Text style={styles.textBold}>Message</Text>
                <Textarea title="Message" wide="80" />
                <Buttonblack title="Submit" wide="80" />
            </View>
        </View>
    )
}

export default Incident

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(30),
        justifyContent: "center",
        alignItems: "center"
    },
    photoContainer: {
        height:hp(38),
        width:wp(80),
        alignSelf: "center"

    },
    viewContainer: {
        backgroundColor: "#FFFFFF",
        flexDirection: "row",
        justifyContent: "space-evenly",
    },
    msgContainer: {
        width: wp(80),
        alignSelf: "center"
    },
    textBold: {
        fontSize:fp(2),
        color: "#000000",
        fontWeight: "bold"
    }
})