import { StyleSheet, Text, View, Image } from 'react-native'
import React from 'react'
import { fp, hp, wp } from '../../helpers/Dimensions'
import Header from '../../components/Header'
import { LOGO } from '../../assets/Icon'
import Buttonblack from '../../components/Buttonblack'
import { useNavigation } from '@react-navigation/native'


const Legalconsent = () => {
    const navigation = useNavigation()

    return (

        <View style={styles.mainContainer}>
            <Header title="Legal Consent" link="" />
            <View style={styles.imgContainer}>
                <Image source={LOGO} />
            </View>
            <View style={styles.textContainer}>
                <Text style={styles.textH2}>USD 15 will be deducted from your earning slater for the inspection.</Text>
            </View>
            <View style={styles.textContainer}>
                <Text style={styles.textNormal}>I, hereby give my full and informed consent. I understand the nature and purpose
                    of this consent, and I acknowledge that I have been given the
                    opportunity to ask questions and have them answered to my satisfaction. By signing this document, I confirm that I am of
                    legal age and sound mind, and I voluntarily agree to the terms set forth herein. This consent is given freely and
                    voluntarily, without any coercion or undue influence.</Text>
            </View>
            <View style={styles.textContainer}>
                <Text style={styles.textH2}>I accept the terms and conditions</Text>
            </View>
            <Buttonblack title="I accept/Continue" wide="90" onPress={() => navigation.navigate("Profilecompleted")} />
        </View>

    )
}

export default Legalconsent

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(20),
        justifyContent: "center",
        alignItems: "center"
    },
    textContainer: {
        backgroundColor: "#FFFFFF",
        width: wp(90),
        //height: hp(20),
        justifyContent: "center",
        //alignItems: "center",
        paddingTop: 20,
        paddingBottom: 20,
        alignSelf: "center"
    },
    textH2: {
        fontSize: fp(2),
        fontWeight: "bold",
        color: "#000000",
        //paddingLeft: 5
    },
    textNormal: {
        fontSize: fp(2),
        color: "#000000"
    },


})