import { Image, KeyboardAvoidingView, Platform, ScrollView, StyleSheet, Text, TextInput, TouchableOpacity, View } from 'react-native'
import React, { useState } from 'react'
import { fp, hp, wp } from '../../helpers/Dimensions'
import Buttonblack from '../../components/Buttonblack'
import Textbox from '../../components/Textbox'
import { useNavigation } from '@react-navigation/native'
import { CAR, CARWHITE, LOGO } from '../../assets/Icon'
import Headerback from '../../components/Headerback'
import Toast from 'react-native-simple-toast';
import { saveToStorage } from '../../utils/storageHelper';
import { BASE_URL } from '../../config'
import { sendOTP } from '../../services/LoginService'

const Login = () => {
    const [mobile, setMobile] = useState('7007308470');
    const navigation = useNavigation();

    const handleLogin = async () => {
        var args = {}
        args['mobile'] = mobile;
        const send_otp_response = await sendOTP(args);
        
        if(send_otp_response){
               if(send_otp_response?.id)
                {
                    saveToStorage("login_dtl", JSON.stringify(send_otp_response));
                    navigation.navigate("Dashboard");
                } else {
                    navigation.navigate("Verify", { mobile });
                }
        }  
    }

    return (

        <KeyboardAvoidingView
      style={{ flex: 1 }}
      behavior={Platform.OS === 'ios' ? 'padding' : 'height'}
      keyboardVerticalOffset={Platform.OS === 'ios' ? 100 : 0}
    >
      <ScrollView
        contentContainerStyle={styles.container}
        keyboardShouldPersistTaps="handled"
      >

      
        <View style={styles.mainContainer}>
            <Headerback title="Login" link="Welcome" />
            <View style={styles.imgContainer}>
                <Image source={LOGO} />
                <Image source={CARWHITE} />
            </View>
            <View style={styles.labelContainer}>
                <Text style={styles.textH2}>Enter Mobile Number</Text>
            </View>
            <View style={styles.textBoxContainer}>
                <Textbox 
                    title="Mobile" 
                    wide="90"
                    val={mobile}
                    changetext={(e) => {
                            const onlyNums = e.replace(/[^0-9]/g, '').slice(0, 10);
                            setMobile(onlyNums)
                        }
                    }
                    keyboardType="number-pad"
                />
            </View>
            <Buttonblack title="Login" wide="90" onPress={handleLogin} />
        </View>
        </ScrollView>
    </KeyboardAvoidingView>
    )
}

export default Login

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(60),
        justifyContent: "center",
        alignItems: "center"
    },
    labelContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(5),
        width: wp(90),
        alignSelf: "center"
    },
    textBoxContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(10),
        alignItems: "center",
        padding: 5

    },
    crtAccContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(40),
        justifyContent: "space-evenly",
        flexDirection: "row"
    },
    textH2: {
        fontSize: fp(2),
        fontWeight: "bold",
        color: "#000000",
        paddingLeft: 5
    },
    textNormal: {
        fontSize: fp(2),
        color: "#000000"
    },
    inpt: {
        width: wp(90),
        borderRadius: 15,
        borderWidth: 1,
        borderColor: "#223138",
        paddingHorizontal: 10
    },
    container: {
        flexGrow: 1,
        justifyContent: 'flex-end',
        //padding: 20,
      },

})