import { StyleSheet, Text, View, Image  } from 'react-native'
import React from 'react'
import { fp, hp, wp } from '../../helpers/Dimensions'
import { LOGO } from '../../assets/Icon'
import Header from '../../components/Header'
import Buttonblack from '../../components/Buttonblack'
import { useNavigation } from '@react-navigation/native'

const Photo = () => {
    const navigation = useNavigation()

  return (
    <View style={styles.mainContainer}>
    <Header title="Photo" link="Documents" />
    <View style={styles.imgContainer}>
        <Image source={LOGO} />
    </View>
    <View style={styles.photoContainer}>
        <View style={styles.photoArea}>
        </View>
    </View>
    <View>
        <Buttonblack title="Take Photo" wide="90" />
        <Buttonblack title="Upload Photo" wide="90" />
        <Buttonblack title="Next" wide="90" onPress={() => navigation.navigate("Vehicle")}/>
    </View>

</View>

  )
}

export default Photo

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(20),
        justifyContent: "center",
        alignItems: "center"
    },
    photoContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(30),
        //width: wp(100),
        justifyContent: "center",
        alignItems: "center"
    },
    photoArea: {
        backgroundColor: "lightgrey",
        textAlign: "center",
        borderRadius: 10,
        height: hp(20),
        width: wp(40)
    },
    textH2: {
        fontSize: fp(2),
        fontWeight: "bold",
        color: "#000000",
        //paddingLeft: 5
    },
    textNormal: {
        fontSize: fp(1.5),
        color: "#000000"
    },


})