import { StyleSheet, Text, View, Image } from 'react-native'
import React, { useEffect, useState } from 'react'
import { fp, hp, wp } from '../../helpers/Dimensions'
import { useNavigation } from '@react-navigation/native'
import { LOGO } from '../../assets/Icon'
import Textbox from '../../components/Textbox'
import Buttonblack from '../../components/Buttonblack'
import Header from '../../components/Header'
import Footer from '../../components/Footer'
import Toast from 'react-native-simple-toast';
import { saveToStorage } from '../../utils/storageHelper'

const Profile = (props) => {
    const [name, setName] = useState('');
    const [email, setEmail] = useState('');
    const [mobile, setMobile] = useState('');
    const [error, setError] = useState('');
    const navigation = useNavigation();

    useEffect(() => {
        fetchProfile(); 
    }, []);

    const fetchProfile = async () => {
        try {
            const apiUrl = 'https://takeme.greathub.in/taxi/api/profile';
            const response = await fetch(apiUrl);
            const result = await response.json();
            
            if (result.status == '1') {
                
                setName(result.data.name);
                setEmail(result.data.email);
                setMobile(result.data.mobile);
            } else {
                Toast.show('There is something wrong');
            }
        } catch (error) {
            console.error('Error fetching profile:', error);
        }
    };


    const handleProfile = () => {
        // Perform validation logic here
        if (name === '') {
            Toast.show('Name cannot be empty');
            return;
        } else if (email === '') {
            Toast.show('Email cannot be empty');
            return;
        } else if (mobile === '') {
            Toast.show('Mobile cannot be empty');
            return;
        } else {
            //Do Nothings
        }

        const apiUrl = 'https://takeme.greathub.in/taxi/api/update-profile';

        try {
            var formdata = new FormData();

            formdata.append('api', 1);
            formdata.append('name', name);
            formdata.append('email', email);
            formdata.append('mobile', mobile);

            var requestOptions = {
                method: 'POST',
                body: formdata,
                redirect: 'follow',
            };
            console.log('formdata', formdata);
            console.log('Console order request', requestOptions);

            fetch(apiUrl, requestOptions)
                .then(response => response.text())
                .then(result => {
                    console.log('Result order', result);
                    if (JSON.parse(result).status == 1) {
                        var resultParse = JSON.parse(result);
                        saveToStorage("login_dtl", JSON.stringify(resultParse.data));
                        Toast.show('Profile successfully updated');
                        setTimeout(() => {
                            navigation.navigate('Dashboard');
                        }, 2000); // 2000 milliseconds delay (2 seconds)                        
                    } else {
                        Toast.show("There is something wrong");
                    }
                })
                // this.props.navigation.navigate('OTPScreen')
                .catch(error => {
                    console.log('error', error);
                });
        } catch (error) {
            console.log('error in catch ', error);
        }
        console.log('error1111111111', error);
    }

    return (
        <View style={styles.mainContainer}>
            <Header title="Profile" link="Login" />
            <View style={styles.contentContainer}>
            <View style={styles.imgContainer}>
                <Image source={LOGO} />
            </View>
            <View style={styles.labelContainer}>
                <Text style={styles.textH2}>Enter your details</Text>
            </View>
            <Textbox title="First Name" wide="90"
                val={name}
                changetext={(e) => setName(e)}
            />
            <Textbox title="Email" wide="90"
                val={email}
                changetext={(e) => setEmail(e)}
            />
            <Textbox title="Mobile" wide="90"
                val={mobile}
                changetext={(e) => setMobile(e)}
            />
            <Buttonblack title="Update Profile" wide="90" onPress={handleProfile} />
            </View>
            <Footer />
        </View>
    )
}

export default Profile

const styles = StyleSheet.create({

    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    contentContainer: {
        backgroundColor: "#F5F5F5",
        width: wp(100),
        height: hp(78)
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(30),
        justifyContent: "center",
        alignItems: "center"
    },
    labelContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(5),
        width: wp(90),
        alignSelf: "center"
    },
    textH2: {
        fontSize: fp(2),
        fontWeight: "bold",
        color: "#000000",
        paddingLeft: 5
    },
    textNormal: {
        fontSize: fp(2),
        color: "#000000"
    },

})