import { StyleSheet, Text, View, Image, Modal, TouchableOpacity, ActivityIndicator } from 'react-native'
import React, { useEffect, useRef, useState } from 'react'

import { fp, hp, wp } from '../../helpers/Dimensions'
import Header from '../../components/Header'

import { DROPICON, FORWARDBUTTON, MAN, MAP, PHONECALL, PICKICON, PIPEICON, STAR } from '../../assets/Icon'
import Buttonwhite from '../../components/Buttonwhite'
import Buttonblack from '../../components/Buttonblack'

import { useNavigation } from '@react-navigation/native'
import { PermissionsAndroid } from 'react-native';

import MapView, { Marker, AnimatedRegion } from 'react-native-maps';
import MapViewDirections from 'react-native-maps-directions';

import Textbox from '../../components/Textbox'
import Geolocation from 'react-native-geolocation-service';
import { getDistance } from 'geolib';

import ProceedToLocation from '../../components/models/ProceedToLocation';
import DriverReached from '../../components/models/DriverReached';

import { getInProcessRide, initiateRides, startRide, updateDriverLatLong, driverOnTheWay, otpVerify, ridePaymentInitiated, completeRide } from '../../services/RideService';
import { GOOGLE_MAPS_API_KEY, RIDESTATUSHASH } from '../../config';
import RideComplete from '../../components/models/RideComplete'

import InitiateRidesData from '../../components/InitiateRides'
import RideNew from '../../components/models/RideNew'

const Rideaccept = () => {
    const navigation = useNavigation()
    const [driver_location, set_driver_location] = useState({ latitude: 0, longitude: 0 });
    const [current_location, set_current_location] = useState({ latitude: 0, longitude: 0 });
    const [pickup_location, set_pickup_location] = useState({ latitude: 0, longitude: 0 });
    const [drop_location, set_drop_location] = useState({ latitude: 0, longitude: 0 });
    const [modalVisible, setModalVisible] = useState(true);
    const [activeModal, setActiveModal] = useState(null);
    const [modalData, setModalData] = useState(null);
    const [loading, setLoading] = useState(false);
    const [rideInfo, setRideInfo] = useState(null);
    const [otp, setOtp] = useState('');
    const [modal_btn_Step, set_modal_btn_step] = useState(null);
    const [rideStarted, setRideStarted] = useState(false);

    const [new_ride, set_new_ride] = useState(null);
    const [current_ride_status, set_current_ride_status] = useState('Proceed To Location');

    const mapRef = useRef(null);
    const trackingInterval = useRef(null);
    const intervalRef = useRef(null);

    const [modalLocVisible, setModalLocVisible] = useState(false);
    const [modalRideVisible, setModalRideVisible] = useState(false);
    

    useEffect(() => {
        //requestLocationPermission();
        rideStatusFuncc();


    }, []);

    

    const requestLocationPermission = async () => {
            if (Platform.OS === 'android') {
              try {
                const granted = await PermissionsAndroid.request(
                  PermissionsAndroid.PERMISSIONS.ACCESS_FINE_LOCATION,
                  {
                    title: 'Location Permission',
                    message: 'This app needs access to your location to show your position on the map.',
                    buttonNeutral: 'Ask Me Later',
                    buttonNegative: 'Cancel',
                    buttonPositive: 'OK',
                  },
                );
                if (granted === PermissionsAndroid.RESULTS.GRANTED) {
                  getLocation();
                  

                } else {
                  console.log('Location permission denied');
                  setLoading(false);
                }
              } catch (err) {
                console.warn(err);
                setLoading(false);
              }
            } else {
              // iOS
              getLocation();
            }
          };
        
          const getLocation = () => {
            Geolocation.getCurrentPosition(
              (position) => {
                set_driver_location({
                    latitude: position.coords.latitude,
                    longitude: position.coords.longitude,
                });
                setLoading(false);
              },
              (error) => {
                console.log('Location error: ', error.message);
                setLoading(false);
              },
              { enableHighAccuracy: true, timeout: 15000, maximumAge: 10000 }
            );
          };


    const rideStatusFuncc = async () => {
        try{
            //const inProcessRide = await getInProcessRide();
            const inProcessRide = await initiateRides();
            if (!inProcessRide || inProcessRide.length === 0) return;

            const ride = inProcessRide[0];
            console.log("rideinfo106=== ", ride);
            setRideInfo(ride);
            const config = RIDESTATUSHASH[ride?.status_name];
            var sts_name = ride?.status_name;
            const formatStatus =  sts_name => sts_name.replace(/_/g, ' ').replace(/\b\w/g, c => c.toUpperCase());
            set_current_ride_status(formatStatus(ride?.status_name));

            if (config) {
                setActiveModal(config.modal);
                config.step && set_modal_btn_step(config.step);
                setModalData(ride);
            }

            if (ride?.driver?.latitude && ride?.driver?.longitude) {
                setLoading(false);
                const initialDriverLocation = {
                    latitude: parseFloat(ride.driver.latitude),
                    longitude: parseFloat(ride.driver.longitude),
                };
                
                console.log("driverloc== ", initialDriverLocation)
                set_driver_location(initialDriverLocation);
                set_current_location(initialDriverLocation);
            }
            var userPickupLocation = {}
            if (ride?.pickup_latitude && ride?.pickup_longitude) {
                userPickupLocation = {
                    latitude: parseFloat(ride.pickup_latitude),
                    longitude: parseFloat(ride.pickup_longitude),
                };
                console.log("userloc== ", userPickupLocation);
                set_pickup_location(userPickupLocation);
            }

            if (ride?.delivery_latitude && ride?.delivery_longitude) {
                const userDropLocation = {
                    latitude: parseFloat(ride.delivery_latitude),
                    longitude: parseFloat(ride.delivery_longitude),
                };
                console.log("userdrop== ", userDropLocation);
                set_drop_location(userDropLocation);

                if(ride?.status_name === 'START_RIDE'){
                setRideStarted(true);
                startRideTracking(ride.id, userPickupLocation, userDropLocation, 'ride-start', ride);
                }
            }
            
            

        }catch (error) {
            console.error("rideinfo-ridestatus-error:", error);
        }
        
    }

    

    const proceedToLocationFunc = async (rideId) => {
        console.log("Proceed clicked for ride:", rideId, driver_location, pickup_location);
        if(rideId, driver_location, pickup_location){
            set_current_ride_status('Proceed To Location');
            const OnTheWayResponse =  await driverOnTheWay(rideId);
            console.log("rideinfo-ontheway=== ", OnTheWayResponse);
            if(OnTheWayResponse){
                setActiveModal(null);
                startRideTracking(rideId, driver_location, pickup_location);
            }
        }

      };

    const cancleRideNav = async (rideId) => {
        navigation.navigate('Cancelride', {ride_id: rideId});
    }

    const otpVerifyFunc = async (otp, rideId, callType) => {
        console.log("Entered OTP:", otp);
        console.log("rideId:", rideId);
        if(otp && rideId){
            const otpVerifyResponse = await otpVerify(rideId, otp);
            console.log("rideinfo-otpverifyresp=== ", otpVerifyResponse);
            if(otpVerifyResponse){
                const config = RIDESTATUSHASH[otpVerifyResponse?.status_name];
                console.log("rideinfo-otpverify198=== ", config);
                if (config) {
                setActiveModal(config.modal);
                config.step && set_modal_btn_step(config.step);
                setModalData(otpVerifyResponse);
            }
                    
            }
        } else if(callType === 'ride_start'){
            setActiveModal(null);
            const startRideResponse  = await startRide(rideId);
            console.log("rideinfo186=== ", startRideResponse);
            setRideStarted(true);
            startRideTracking(rideId, pickup_location, drop_location, 'ride-start', startRideResponse);
            
        }


    }


      const startRideTracking = (rideId, src, dest, callType, rideDtl) => {
        console.log("rideDtl202=== ", rideDtl);
        if (!src || !dest) return;

        if (trackingInterval.current) {
            clearInterval(trackingInterval.current);
            trackingInterval.current = null;
        }

        let progress = 0; 
        let hasStartedPollingNewRide = false;
        let newRidePollInterval = null;

        const distance = getDistance(src, dest); // Calculate distance in meters
        const step = distance > 1000 ? 0.02 : 0.05; // Adjust movement step based on distance

        console.log("Starting Live Tracking...");

        trackingInterval.current = setInterval(() => {
            progress += step;

            const newLat = src.latitude + (dest.latitude - src.latitude) * progress;
            const newLng = src.longitude + (dest.longitude - src.longitude) * progress;
            const newPosition = { latitude: newLat, longitude: newLng };

            console.log("Updating Driver Location:", newPosition);
            set_current_location(newPosition);

            const remainingDistance = getDistance(newPosition, dest);
            console.log("Remaining Distance:", remainingDistance);

            if ((callType === 'ride-start') && (remainingDistance <= 500 && !hasStartedPollingNewRide)) {
            hasStartedPollingNewRide = true;

            newRidePollInterval = setInterval(async () => {
                const hasRide = await newRideChecker(); // Should return true when new ride assigned

                if (hasRide) {
                    clearInterval(newRidePollInterval); // Stop checking
                }
            }, 2000);
        }

            if (remainingDistance <= 50 || progress >= 1) {
                clearInterval(trackingInterval.current);
                if(callType === 'ride-start'){
                    RideCompleteModal(rideId, rideDtl);
                }else{
                    updateDriverLatLongFunc(rideId);
                }
                                
            }

        }, 2000);
    };

    const updateDriverLatLongFunc = async (rideId) => {
        console.log("rideinfo176: ", rideId);
        const updateDriverLocResp = await updateDriverLatLong(rideId);
        console.log("rideinfo178:  ", updateDriverLocResp);
        if(updateDriverLocResp){
            if(updateDriverLocResp.status_name === 'DRIVER_ARRIVED') {
                set_current_ride_status('Arrived To Pick Up Location')  
                const config = RIDESTATUSHASH[updateDriverLocResp?.status_name];
                if (config) {
                    setActiveModal(config.modal);
                    config.step && set_modal_btn_step(config.step);
                    setModalData(updateDriverLocResp);
                }
                
            }
        }

    }

    const handleModal = (data) => {
        console.log("Modal Action Triggered With:", data);
        setActiveModal(null);
    };

    const closeModal = () => {
        setActiveModal(null);
    };

    const handleRideStart = () => {
        setRideStarted(true);
        startRideTracking(rideInfo.id, pickup_location, drop_location, 'ride-start');
      };

    const RideCompleteModal = (rideId, rideDtl) => {
        
        const config = RIDESTATUSHASH['COMPLETE'];
            if (config) {
                console.log("rideinfo268===e ", rideDtl);
                setActiveModal(config.modal);
                config.step && set_modal_btn_step(config.step);
                setModalData(rideDtl);
            }

    }

    const RideCompleteFunc = async (rideId) => {
        console.log("rideinfo277=== ", rideId);
        try {
            const paymntInitiatResponse  = await ridePaymentInitiated(rideId);
            console.log("rideinfo-paymntInitiatResponse=== ", paymntInitiatResponse);
            if(paymntInitiatResponse){
                navigation.navigate("Payment", {ride_id:rideId});
                {/*const config = RIDESTATUSHASH['PAYMENT_INITIATED'];
                if (config) {
                    setActiveModal(config.modal);
                    setModalData(paymntInitiatResponse);
                } */}   
            }            
          } catch (error) {
            console.error("Error accepting ride:", error);
          }
    }
    
    const PaymentInitiatedFunc = async (rideId) => {
        
    }

////////////////////////////////////////
        const fetchNewRide = async () => {
            const initiateRidesResponse = await initiateRides();
            console.log("payment31=== ", initiateRidesResponse);
    
            if (!initiateRidesResponse || initiateRidesResponse.length === 0) return;
    
            const filtered = initiateRidesResponse.filter(ride => ride.status_name === 'PENDING')
                .map(ride => ({
                            ...ride,
                            queued: 1,
                })
            );
            
            if(filtered.length > 0 ){
                console.log("payment45===", filtered)
                var filtered_ride = filtered[0];
                var modify_status_name = filtered_ride?.queued == 1 ? 'QUEUED' : '';
    
                const config = RIDESTATUSHASH[modify_status_name];
                console.log("payment47===", config);
                if (config) {
                    setActiveModal(config.modal);
                    setModalData(filtered_ride);
                    return true;
                }
            }
            return false;
    
            //clearInterval(intervalRef.current);
                
        }
////////////////////////////////////
    


    if (loading) {
        return (
            <View style={{ flex: 1, justifyContent: "center", alignItems: "center" }}>
                <ActivityIndicator size="large" color="#0000ff" />
            </View>
        );
    }


    return (
        <View style={styles.mainContainer}>
            <View style={styles.headerContainer}>
                <Text style={styles.txtNormalBold}>{current_ride_status}</Text>
            </View>
            {driver_location.latitude !== 0 && pickup_location.latitude !== 0 ? (
                <MapView
    ref={mapRef}
    style={styles.map}
    initialRegion={{
      ...current_location,
      latitudeDelta: 0.05,
      longitudeDelta: 0.05,
    }}
    onMapReady={() => {
      if (mapRef.current) {
        const points = rideStarted
          ? [pickup_location, drop_location]
          : [driver_location, pickup_location];

        mapRef.current.fitToCoordinates(points, {
          edgePadding: { top: 60, right: 60, bottom: 60, left: 60 },
          animated: true,
        });
      }
    }}
  >
    {/* Animated Driver Marker */}
    <Marker coordinate={current_location} title="Driver Location">
      <Image source={MAN} style={{ width: 40, height: 40 }} />
    </Marker>

    {/* Pickup & Drop Markers */}
    <Marker coordinate={pickup_location} title="Pickup Location" />
    {rideStarted && <Marker coordinate={drop_location} title="Drop-off Location" />}

    {/* Route Directions */}
    <MapViewDirections
      origin={rideStarted ? pickup_location : driver_location}
      destination={rideStarted ? drop_location : pickup_location}
      apikey={GOOGLE_MAPS_API_KEY}
      strokeWidth={4}
      strokeColor="blue"
    />
  </MapView>
                ) : (
                <Text>Loading map...</Text>

            )}

            {/*  Modal Proceed To Location*/}
            <ProceedToLocation
                    visible={activeModal === 'proceed_to_location'}
                    onClose={closeModal}
                    handleModal={handleModal}
                    data={modalData}
                    functionName={proceedToLocationFunc}
                    cancleRideFunc={cancleRideNav}
                />

            {/*  Modal Reached Location*/}
           
            <DriverReached
                    visible={activeModal === 'driver_arrived'}
                    onClose={closeModal}
                    handleModal={handleModal}
                    data={modalData}
                    functionName={otpVerifyFunc}
                    otp={otp}
                    setOtp={setOtp}
                    modalBtnStep={modal_btn_Step}
                    cancleRideFunc={cancleRideNav}

            />

            {/*  Ride Complete*/}

            <RideComplete
                    visible={activeModal === 'ride_complete'}
                    onClose={closeModal}
                    handleModal={handleModal}
                    data={modalData}
                    functionName={RideCompleteFunc}
            />

            {/*  Ride Payment Initiated */}

            {/*<PaymentInitiated
                    visible={activeModal === 'payment_initiated'}
                    onClose={closeModal}
                    handleModal={handleModal}
                    data={modalData}
                    functionName={PaymentInitiatedFunc}
            />*/}
            

        <RideNew
            visible={activeModal === 'queued_ride'}
            onClose={closeModal}
            handleModal={handleModal}
            data={modalData}
        />  

    </View>

    )
}

export default Rideaccept

const styles = StyleSheet.create({
    map: {
        flex: 1,
    },
    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        width: wp(100)
    },
    headerContainer: {
        backgroundColor: "#FFC727",
        width: wp(100),
        height: hp(10),
        borderBottomEndRadius: 20,
        borderBottomLeftRadius: 20,
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "flex-start",
        paddingLeft: 20
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(20),
        justifyContent: "center",
        alignItems: "center"
    },
    modalContainer: {
        flex: 1,
        justifyContent: "flex-end",
        margin: 10
    },
    modalView: {
        backgroundColor: "#FFFFFF",
        borderRadius: 20,
        width: wp(95),
        //height: hp(40),
        alignSelf: "center",
        paddingTop: 10,
        paddingBottom: 10
    },
    modalL1View: {
        backgroundColor: "#FFFFFF",
        flexDirection: "row",
        justifyContent: "space-between",
        width: wp(90),
        //height: hp(25),
        margin: 10
    },
    modalL2View: {
        backgroundColor: "#FFFFFF",
        //width: wp(90),
        //alignSelf: "center",
        flexDirection: "row",
        justifyContent: "space-between"
    },
    modalTextBold: {
        fontSize: fp(2),
        fontWeight: "bold",
        color: "#000000",
    },
    modalText: {
        fontSize: fp(2),
        color: "#000000",
    },
    modalBtnContainer: {
        backgroundColor: "#FFFFFF",
        width: wp(90),
        alignSelf: "center",
        //flexDirection: "row",
        justifyContent: "center",
        alignItems: "center"
    },
    starContainer: {
        width: wp(30),
        flexDirection: "row",
        justifyContent: "space-evenly"
    },
    greyline: {
        backgroundColor: "lightgrey",
        color: "lightgrey",
        alignSelf: "center",
        width: wp(30),
        height: hp(0.7),
        //paddingTop: 10
    },
    modalFeedbackContainer: {
        flex: 1,
        justifyContent: "flex-end",
        margin: 0
    },
    modalFeedbackView: {
        backgroundColor: "#FFFFFF",
        borderRadius: 20,
        width: wp(95),
        height: hp(55),
        alignItems: "center",
        alignSelf: "center",
        paddingTop: 10
    },
    otpContainer: {
        width: wp(90),
        alignItems: "center",
        margin: 10
    },
    textSmall: {
        color: "#000000",
    },
    txtSmall: {
        color: "#000000",
        fontSize: fp(1.5),
    },
    txtSmallBold: {
        color: "#000000",
        fontSize: fp(1.5),
        fontWeight: "bold"
    },
    txtNormal: {
        color: "#000000",
        fontSize: fp(2),
    },
    txtNormalBold: {
        color: "#000000",
        fontSize: fp(2),
        fontWeight: "bold"
    },
    txtNormalRed: {
        color: "red",
        fontSize: fp(2),
    },
    txtLarge: {
        color: "#000000",
        fontSize: fp(2.2),
    },
    txtLargeBold: {
        color: "#000000",
        fontSize: fp(2.2),
        fontWeight: "bold"
    },
    
})