import { StyleSheet, Text, View, Image, Modal } from 'react-native'
import React, { useState } from 'react'
import { fp, hp, wp } from '../../helpers/Dimensions'
import Header from '../../components/Header'
import { DROPICON, MAN, MAP, PICKICON, PIPEICON, STAR } from '../../assets/Icon'
import Buttonwhite from '../../components/Buttonwhite'
import Buttonblack from '../../components/Buttonblack'
import { useNavigation } from '@react-navigation/native'

const Rideend = () => {
    const { modalVisible, setModalVisible } = useState(false);
    const navigation = useNavigation()

    return (
        <View style={styles.mainContainer}>
            <Header title="Ride End" link="Profile" />
            <Image source={MAP} />

            <Modal
                transparent={true}
                visible={modalVisible}
            >
                <View style={styles.modalContainer}>
                    <View style={styles.modalView}>
                        <View style={styles.modalL1View}>
                            <View style={{ backgroundColor: "#FFFFFF", width: wp(20) }}>
                                <Image source={MAN} />
                            </View>
                            <View style={{ width: wp(50) }}>
                                <Text style={styles.modalTextBold}>George Jacob</Text>
                                <View style={[styles.starContainer, { width: wp(20) }]}>
                                    <Image source={STAR} />
                                    <Image source={STAR} />
                                    <Image source={STAR} />
                                    <Image source={STAR} />
                                    <Image source={STAR} />
                                </View>
                                <Text style={styles.textSmall}>USD 6 - USD 9</Text>
                            </View>
                            <View style={{ width: wp(20) }}></View>
                        </View>
                        <View style={styles.modalL1View}>
                            <View style={styles.modalL2View}>
                                <View style={{ width: wp(20), paddingLeft: 20 }}>
                                    <Image source={PICKICON} />
                                </View>
                                <View style={{ width: wp(50) }}>
                                    <Text style={styles.modalTextBold}>Douglas Crecent Road</Text>
                                    <Text style={styles.textSmall}>5 min (1.8 mi) away</Text>
                                </View>
                            </View>
                        </View>
                        <View style={styles.modalL1View}>
                            <View style={styles.modalL2View}>
                                <View style={{ width: wp(20), paddingLeft: 20 }}>
                                    <Image source={DROPICON} />
                                </View>
                                <View style={{ width: wp(50) }}>
                                    <Text style={styles.modalTextBold}>Douglas Crecent Road</Text>
                                    <Text style={styles.textSmall}>5 min (1.8 mi) away</Text>
                                </View>
                            </View>
                        </View>
                        <View style={styles.modalBtnContainer}>
                            <Buttonblack title="Ride End" wide="80" onPress={() => navigation.navigate("Payment")} />
                        </View>
                    </View>
                </View>
            </Modal>
        </View>
    )
}

export default Rideend

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(20),
        justifyContent: "center",
        alignItems: "center"
    },
    modalContainer: {
        flex: 1,
        justifyContent: "flex-end",
        margin: 0
    },
    modalView: {
        backgroundColor: "#FFFFFF",
        borderTopEndRadius: 20,
        borderTopLeftRadius: 20,
        width: wp(95),
        height: hp(40),
        alignSelf: "center",
        paddingTop: 10
    },
    modalL1View: {
        backgroundColor: "#FFFFFF",
        flexDirection: "row",
        justifyContent: "space-between",
        width: wp(90),
        //height: hp(25),
        margin: 10
    },
    modalL2View: {
        backgroundColor: "#FFFFFF",
        //width: wp(90),
        //alignSelf: "center",
        flexDirection: "row",
        justifyContent: "space-between"
    },
    modalTextBold: {
        fontSize: fp(2),
        fontWeight: "bold",
        color: "#000000",
    },
    modalText: {
        fontSize: fp(2),
        color: "#000000",
    },
    modalBtnContainer: {
        backgroundColor: "#FFFFFF",
        width: wp(90),
        alignSelf: "center",
        flexDirection: "row",
        justifyContent: "space-around",
        alignItems: "center"
    },
    starContainer: {
        width: wp(30),
        flexDirection: "row",
        justifyContent: "space-evenly"
    },
    greyline: {
        backgroundColor: "lightgrey",
        color: "lightgrey",
        alignSelf: "center",
        width: wp(30),
        height: hp(0.7),
        //paddingTop: 10
    },
    modalFeedbackContainer: {
        flex: 1,
        justifyContent: "flex-end",
        margin: 0
    },
    modalFeedbackView: {
        backgroundColor: "#FFFFFF",
        borderRadius: 20,
        width: wp(95),
        height: hp(55),
        alignItems: "center",
        alignSelf: "center",
        paddingTop: 10
    },
    textSmall: {
        color: "#000000",
    }
})