import AsyncStorage from '@react-native-async-storage/async-storage';

export const saveToStorage = async (key, value) => {
    try {
        await AsyncStorage.setItem(key, value);
    } catch (error) {
        console.error(`Error saving data for key "${key}":`, error);
    }
};

export const getFromStorage = async (key, defaultValue = null) => {
    try {
        const value = await AsyncStorage.getItem(key);
        return value !== null ? value : defaultValue;
    } catch (error) {
        console.error(`Error retrieving data for key "${key}":`, error);
        return defaultValue;
    }
};

export const removeFromStorage = async (key) => {
    try {
        await AsyncStorage.removeItem(key);
    } catch (error) {
        console.error(`Error removing data for key "${key}":`, error);
    }
};
