<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

use App\Models\Parcels;
//use App\Notifications\RideReminderNotification;
use Carbon\Carbon;


class SendScheduledRideNotifications extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'notify:scheduled-rides';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send 30-minute before reminders for scheduled rides';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */

    public function handle()
    {
        $targetTime = Carbon::now()->addMinutes(30)->format('Y-m-d H:i');

        $rides = Parcels::whereNotNull('schedule_date')
            ->where('status', '11')
            ->whereRaw("DATE_FORMAT(schedule_date, '%Y-%m-%d %H:%i') = ?", [$targetTime])
            ->get();

        foreach ($rides as $ride) {
            if ($ride->user_id && $ride->customer->fcm_token) {
                $ride->customer->notify(new RideReminderNotification($ride));
            }

            if ($ride->driver && $ride->driver->fcm_token) {
                $ride->driver->notify(new RideReminderNotification($ride));
            }
        }

        $this->info("Notifications sent for " . $rides->count() . " rides.");
    }

}
