<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Ratchet\Http\HttpServer;
use Ratchet\Server\IoServer;
use Ratchet\WebSocket\WsServer;
use Ratchet\MessageComponentInterface;
use Ratchet\ConnectionInterface;
use React\Socket\Server as ReactServer;
use React\EventLoop\Factory as LoopFactory;
use App\WebSockets\WebSocketHandler;

class WebSocketServer extends Command
{
    protected $signature = 'websocket:serve';
    protected $description = 'Start WebSocket Server';

    public function handle()
    {
        $this->info("Starting WebSocket Server...");

        $loop = LoopFactory::create();
        $webSock = new ReactServer('0.0.0.0:6003', $loop);

        $server = new IoServer(
            new HttpServer(
                new WsServer(
                    new WebSocketHandler()
                )
            ),
            $webSock,
            $loop
        );

        $server->run();
    }
}


