<?php
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;

if (!function_exists('example_helper')) {
    function example_helper()
    {
        return 'This is an example helper function!';
    }

    function logged_in()
    {
        $TYPE = 'admin';
        if(app()->request->session()->has($TYPE) && isset(app()->request->session()->has($TYPE)['logged_in'])){
            return true;
        }else{
            if(isset($_POST['api']) && $_POST['api'] == 1){
                $ret_data = array('status' => '1', 'logged_in' => 0, 'message' => 'Login Required.', 'data' => array());
                header('Content-Type: application/json');
                echo json_encode($ret_data);
                die();
            }
            return false;
        }
    }
    
    function is_auth()
    {
        $TYPE = 'admin';
        if(app()->request->session()->has($TYPE) && isset(app()->request->session()->has($TYPE)['logged_in'])){
            if(isset($_POST['api']) && $_POST['api'] == 1){
                $ret_data = array('status' => '1', 'message' => 'Already Login.', 'data' => array());
                header('Content-Type: application/json');
                echo json_encode($ret_data);
                die();
            }else{
                return redirect()->away("/$TYPE/dashboard")->send();
            }
        }
    }
    
    function is_login()
    {
        $TYPE = 'admin';
        if(app()->request->session()->has($TYPE) && isset(app()->request->session()->has($TYPE)['logged_in'])){
    
        }else{
            if(isset($_POST['api']) && $_POST['api'] == 1){
                $ret_data = array('status' => '0', 'message' => 'Login First.', 'data' => array());
                header('Content-Type: application/json');
                echo json_encode($ret_data);
                die();
            }else{
                return redirect()->away("/$TYPE/login")->send();
            }
        }
    }

    function days($type = NULL)
    {
        $array = array(1=>"Monday", 2=>"Tuesday", 3=>"Wednesday", 4=>"Thursday", 5=>"Friday", 6=>"Saturday", 7=>"Sunday");
        if(isset($type) && $array[$type]){
            return $array[$type];
        }
        return $array;
    }

    function payment_option($type = NULL)
    {
        $array = array(1=>"Cash", 2=>"Wallet", 3=>"Online Payment");
        if(isset($type) && $array[$type]){
            return $array[$type];
        }
        return $array;
    }

    function distance_unit($type = NULL)
    {
        $array = array("miles"=>"Miles", "km"=>"KM");
        if(isset($type) && $array[$type]){
            return $array[$type];
        }
        return $array;
    }

    function weight_unit($type = NULL)
    {   
        $array = array("pound"=>"Pound", "kg"=>"KG");
        if(isset($type) && $array[$type]){
            return $array[$type];
        }
        return $array;
    }

    function country($id = NULL)
    {
        if($id){
            $country = DB::table('country')->select("id","name")->where('status', '1')->where('id', $id)->orderBy('name')->first();
        }else{
            $country = DB::table('country')->select("id","name")->where('status', '1')->orderBy('name')->get();
        }
        return $country;
    }

    function currency($id = NULL)
    {
        if($id){
            $currency = DB::table('currency')->select("id","name")->where('status', '1')->where('id', $id)->orderBy('name')->first();
        }else{
            $currency = DB::table('currency')->select("id","name")->where('status', '1')->orderBy('name')->get();
        }
        return $currency;
    }
}

// Add more custom helper functions below as needed

