<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Validator;
use App\Models\Drivers;
use App\Models\Location;
use App\Models\Category;

class DriverController extends Controller
{
	public function index()
  	{
        $data = [];
        $url = url('/');
        $location = Location::where('status', '1')->orderBy('name')->get();
        $category = Category::where('status', '1')->orderBy('name')->get();
        $data['TYPE'] = 'taxi/admin';
        $data['location'] = $location;
        $data['category'] = $category;
  		return view('admin.driver.index',$data);
	}

    public function index_ajax_driver_list()
    {
        #logged_in();
        $availability_array = array(0=>"Unavailable",1=>"Available");
        $verified_array = array(0=>"Pending",1=>"Verified","Rejected");
        $status_array = array(0=>"Idle",1=>"Active",2=>"Delete");
        $recordsTotal = Drivers::count_all();
        $data = Drivers::get_data_table();
        if($data)
        {
            foreach ($data as $row)
            {
                $id = $row->id;
                $row->availability_label = isset($availability_array[$row->availability]) ? $availability_array[$row->availability] : 'Unavailable';
                $row->verified_label = isset($verified_array[$row->verified]) ? $verified_array[$row->verified] : 'NA';
                $row->status_label = isset($status_array[$row->status]) ? $status_array[$row->status] : 'NA';

                if($row->profile_photo){
                    $row->profile_img = url('').'/driver/'.$id.'/'.$row->profile_photo;
                }
                if($row->adhar){
                    $row->adhar_img = url('').'/driver/'.$id.'/'.$row->adhar;
                }
                if($row->registration_certificate){
                    $row->registration_certificate_img = url('').'/driver/'.$id.'/'.$row->registration_certificate;
                }
                if($row->vehicle_insurance){
                    $row->vehicle_insurance_img = url('').'/driver/'.$id.'/'.$row->vehicle_insurance;
                }
                if($row->driving_licence){
                    $photo_array = array();
                    $driving_licence = json_decode($row->driving_licence);
                    if($driving_licence){
                        foreach($driving_licence as $ph){
                            $photo_array[] = url('').'/driver/'.$id.'/'.$ph;
                        }
                    }
                    $row->driving_licence_img = $photo_array;
                }
                if($row->vehicle_photo){
                    $photo_array = array();
                    $vehicle_photo = json_decode($row->vehicle_photo);
                    if($vehicle_photo){
                        foreach($vehicle_photo as $ph){
                            $photo_array[] = url('').'/driver/'.$id.'/'.$ph;
                        }
                    }
                    $row->vehicle_photo_img = $photo_array;
                }

                $row->rating = 0;
                $row->wallet_balance = 0;
            }
        }
        $output = array(
                'status'=>1,
                'message'=>'success',
                "recordsTotal" => $recordsTotal,
                "recordsFiltered" => $recordsTotal,
                "data" => $data,
                );

        return Response::json($output, 200);
    }

    public function save(Request $request)
    {
        $customMessages = [
            'name' => 'My Name is Required',
        ];

        $id = $request->id;
        $validator = Validator::make($request->all(),[
            'location' => 'required',
            'category' => 'required',
        ], $customMessages);

        if($validator->fails())
              return $this->setValidatorError($validator,1);

        if($request->id){
            $data =  Drivers::find($request->id);
        }else{
            $data = new Drivers;
        }
        $data->name = $request->name;
        $data->gender = $request->gender;
        $data->email = $request->email;
        $data->mobile = $request->mobile;
        $data->address = $request->address;
        $data->availability = $request->availability;
        $data->verified = $request->verified;

        $data->category = $request->category;
        $data->location = $request->location;
        $data->model = $request->model;
        $data->brand = $request->brand;
        $data->year_of_manufacture = $request->year_of_manufacture;
        $data->registration_number = $request->registration_number;
        $data->vehicle_category = $request->vehicle_category;
        $data->commission = $request->commission;
        $data->save();

        if($request->id){
            $msg = 'Updated';
        }else{
            $id = $data->id;
            $msg = 'Inserted';
            $data =  Drivers::find($id);
        }

        $path = root_path().'/driver/'.$id;
        $vehicle_photo = '';
        $vp_array = array();
        if ($request->hasfile('vehicle_photo')) {
            foreach ($request->file('vehicle_photo') as $file) {
                $file_name = time() . '.' . $file->extension();
                $file->move($path, $file_name);
                $vp_array[] = $file_name;
            }
        }
        if($vp_array){
            $vehicle_photo = json_encode($vp_array);
        }

        $driving_licence = '';
        $dl_array = array();
        if ($request->hasfile('driving_licence')) {
            foreach ($request->file('driving_licence') as $file) {
                $file_name = time().'_'.$file->getClientOriginalName();
                $file->move($path, $file_name);
                $dl_array[] = $file_name;
            }
        }
        if($dl_array){
            $driving_licence = json_encode($dl_array);
        }

        $profile_photo = '';
        if($request->hasFile('profile_photo')){
            $file = $request->file('profile_photo');
            $OriginalName = $file->getClientOriginalName();
            $filename = pathinfo($OriginalName, PATHINFO_FILENAME);
            $profile_photo = time() . '_' .$filename. '.' .$file->extension();
            $file->move($path, $profile_photo);
        }
        $adhar = '';
        if($request->hasFile('adhar')){
            $file = $request->file('adhar');
            $OriginalName = $file->getClientOriginalName();
            $filename = pathinfo($OriginalName, PATHINFO_FILENAME);
            $adhar = time() . '_' .$filename. '.' .$file->extension();
            $file->move($path, $adhar);
        }
        $vehicle_insurance = '';
        if($request->hasFile('vehicle_insurance')){
            $file = $request->file('vehicle_insurance');
            $OriginalName = $file->getClientOriginalName();
            $filename = pathinfo($OriginalName, PATHINFO_FILENAME);
            $vehicle_insurance = time() . '_' .$filename. '.' .$file->extension();
            $file->move($path, $vehicle_insurance);
        }
        $registration_certificate = '';
        if($request->hasFile('registration_certificate')){
            $file = $request->file('registration_certificate');
            $OriginalName = $file->getClientOriginalName();
            $filename = pathinfo($OriginalName, PATHINFO_FILENAME);
            $registration_certificate = time() . '_' .$filename. '.' .$file->extension();
            $file->move($path, $registration_certificate);
        }
        if($profile_photo){
            $data->profile_photo = $profile_photo;
        }
        if($adhar){
            $data->adhar = $adhar;
        }
        if($vehicle_insurance){
            $data->vehicle_insurance = $vehicle_insurance;
        }
        if($driving_licence){
            $data->driving_licence = $driving_licence;
        }
        if($registration_certificate){
            $data->registration_certificate = $registration_certificate;
        }
        if($vehicle_photo){
            $data->vehicle_photo = $vehicle_photo;
        }
        $data->save();

        return Response::json([
                        'status'  => true,
                        'message' => 'Driver '.$msg.' Successfully',
                        ]);

    }

    public function enable(Request $request)
    {
        $id = $request->id;
        $validator = Validator::make($request->all(),[
            'id' => 'required',
        ]);

        if($validator->fails())
              return $this->setValidatorError($validator,1);

        if($request->id){
            $data =  Drivers::find($request->id);
        }
        $data->status = '1';
        $data->save();

        $msg = 'enabled';

        return Response::json([
                        'status'  => true,
                        'message' => 'Driver '.$msg.' Successfully',
                        ]);

    }

    public function disable(Request $request)
    {
        $id = $request->id;
        $validator = Validator::make($request->all(),[
            'id' => 'required',
        ]);

        if($validator->fails())
              return $this->setValidatorError($validator,1);

        if($request->id){
            $data =  Drivers::find($request->id);
        }
        $data->status = '0';
        $data->save();

        $msg = 'disabled';

        return Response::json([
                        'status'  => true,
                        'message' => 'Driver '.$msg.' Successfully',
                        ]);

    }
}
