<?php

namespace App\Http\Controllers\Api\Driver;

use App\Http\Controllers\Controller;

use App\Http\Requests\StoreBankDetailRequest;
use App\Services\BankDetailService;
use Illuminate\Http\Request;

class BankDetailController extends Controller
{
    protected $service;
    
    public function __construct(BankDetailService $service)
    {
        $this->service = $service;
    }

	public function getBankDetail(Request $request)
	{
		$login_detail = $request->login_detail;
		$driver_login_id = $login_detail['login_id'];
		$bankDetail = $this->service->getBankDetailsByDriverId($driver_login_id);
        if($bankDetail)
		return apiResponse(1, 'Bank Detail', $bankDetail, 200);
        else
        return apiResponse(0, 'There is no data.', '', 200);
        
	}
    
    public function store(StoreBankDetailRequest $request)
    {
	$login_detail = $request->login_detail;	
        $validated  = $request->validated();
        $validated['driver_id'] = $login_detail['login_id'];

	$bankDetail = $this->service->getBankDetailsByDriverId($validated['driver_id']);     
	if($bankDetail)
	{
		$bankDetail = $this->service->updateBankDetails($login_detail['login_id'], $validated);
	}
	else 
	{
        	$bankDetail = $this->service->saveBankDetails($validated);
	}

	return apiResponse(1, 'Updated Successfully', $bankDetail, 200);	
    }

    public function update(StoreBankDetailRequest $request, $id)
    {
        $validated = $request->validated();

        $bankDetail = $this->service->updateBankDetails($id, $validated);

        return response()->json($bankDetail, 200);
    }
 
}


