<?php
        
namespace App\Http\Controllers\Api\Driver;

use App\Http\Controllers\Controller;
use App\Http\Requests\IncidentRequest;
use App\Services\IncidentService;
use Illuminate\Http\JsonResponse;

class IncidentController extends Controller
{
    protected $service;

    public function __construct(IncidentService $service)
    {
        $this->service = $service;
    }

    public function store(IncidentRequest $request): JsonResponse
    {
        $result = $this->service->saveIncident($request->validated());

        return apiResponse(1, 'Incident submitted successfully.', $result, 200); 
    }
}

