<?php

namespace App\Http\Controllers\Api\Driver;

use App\Models\Drivers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

use App\Http\Requests\FileUploadRequest;
use App\Services\FileUploadService;

use App\Http\Requests\UploadDoc;
use App\Services\UploadDocService;
use App\Services\CarTypeService;

use App\Repositories\DriverRepository;



class Profile extends Controller
{
    protected $fileUploadService;
    protected $driverRepository;
    protected $uploadDocService;
    protected $carTypeService;	


    public function __construct(FileUploadService $fileUploadService, DriverRepository $driverRepository, UploadDocService $uploadDocService, CarTypeService $carTypeService)
    {
        $this->fileUploadService= $fileUploadService;
        $this->driverRepository = $driverRepository;
		$this->uploadDocService = $uploadDocService;
        $this->carTypeService   = $carTypeService;

    }

    public function updateProfile(Request $request)
    {
        $validator = $this->validateRequest($request);

        if($validator->fails())
        return $this->setValidatorError($validator, 1);

        $validatedData = $validator->validated();

        //$driver_obj = auth('api_driver')->user();
		$login_detail = $request->session()->get('driver');
        if(!$login_detail)
		return apiResponse(0, 'There is no data.', '', 400);	

        $driver_login   = $login_detail; //$driver_obj->toArray();
        $userDetail     = $this->updateDetail($validatedData, $driver_login);
        
        return apiResponse(1, $userDetail['message'], $userDetail['data'], 200);  
    }

    public function validateRequest(Request $request)
    {
        return Validator::make($request->all(), [
            'email' => 'required|email',
            'name' => 'required|string|max:50',
            'address' => 'nullable|string|max:200'
        ]);
    }

    private function updateDetail($validatedData, $driver_login)
    {
        $userDetail = Drivers::where('mobile', $driver_login['mobile'])->first();

        if ($userDetail) {
            $userDetail->update([
            	'name' 	    => $validatedData['name'],
                'email' 	=> $validatedData['email'],
                'address' 	=> isset($validatedData['address']) && $validatedData['address'] ? $validatedData['address'] : null,
            ]);

            return ['message' => 'Details updated successfully.', 'data'=>$userDetail];
        } 
    }

    public function updatec(FileUploadRequest $request)
    {
        //$validatedData = $request->validated();
         
        #$driver_obj = auth('api_driver')->user();
        #print_r($driver_obj); 
    }
    public function upload(FileUploadRequest $request, Drivers $driver)
    {
        $driver_obj     = auth('api_driver')->user();
        $driver_object = $driver_obj ? $driver_obj->toArray() : [];
        if(empty($driver_object['id']))
        {
        return response()->json([
            'success' => false,
            'message' => 'Login Required.',
            'data' => null
        ], 400); 
        }
     
        $files = [
            'registration_certificate'  => $request->file('registration_certificate') ? [$request->file('registration_certificate')] : [],
            'vehicle_insurance'         => $request->file('vehicle_insurance') ? [$request->file('vehicle_insurance')] : [],
            'driving_licence'           => $request->file('driving_licence') ? [$request->file('driving_licence')] : [],
            'profile_photo'             => $request->file('profile_photo') ? [$request->file('profile_photo')] : [],
            'vehicle_photo'             => $request->file('vehicle_photo') ? [$request->file('vehicle_photo')] : [],
        ];

        //\Log::info('vehicle_photo==', [$request->file('vehicle_photo')]);
 
        #$filePaths = $this->fileUploadService->uploadMultiple($request->only(['registration_certificate', 'vehicle_insurance', 'driving_licence', 'profile_photo']));
        $filePaths = $this->fileUploadService->uploadMultiple($files);
        $updatedDriver  = $this->driverRepository->save($driver, $filePaths, $request->all(), $driver_obj['id']);

        return response()->json([
            'success' => true,
            'message' => 'Files and vehicle information have been uploaded and saved successfully.',
            'data' => $updatedDriver
        ], 200);
    } 

	public function driver_dtl(UploadDoc $request, Drivers $driver)
	{
		$login_detail = $request->login_detail;
        $login_driver_id = $login_detail['login_id'];
		$driver_obj = $this->uploadDocService->getDriverInfo($login_detail);
		return apiResponse(1, 'Driver Information', $driver_obj, 200);
	}

	public function driver_profile(Request $request)
	{
		$login_detail = $request->login_detail;
		$login_driver_id = $login_detail['login_id'];
		$driver_obj = $this->uploadDocService->getDriverInfo($login_detail);
		$profile_detail = [];
		$profile_detail['name'] = $driver_obj->name;
		$profile_detail['mobile'] = $driver_obj->mobile;
		$profile_detail['email'] = $driver_obj->email;
		$profile_detail['address'] = $driver_obj->address;
        $profile_detail['profile_photo'] = $driver_obj->profile_photo;
        
		
		return apiResponse(1, 'Profile', $driver_obj, 200);
	} 
      
	public function vehicleInfo(Request $request)
	{
		$login_detail = $request->login_detail;
		$driver_obj = $this->uploadDocService->getDriverInfo($login_detail);
		$dl = $driver_obj->driving_licence;
		$paths = explode(',', $dl);
		$domain = request()->getSchemeAndHttpHost();

		$vehicle = [];
		$vehicle['dl_front'] 		= $domain . '/storage/' . $paths[0];
		$vehicle['dl_back']  		= $domain . '/storage/' . $paths[1];
		$vehicle['vehicle_type']  	= $driver_obj->vehicle_type;
		$vehicle['vehicle_make']  	= $driver_obj->brand;
		$vehicle['vehicle_model']  	= $driver_obj->model;
		$vehicle['vehicle_year']  	= $driver_obj->year_of_manufacture;
		$vehicle['vehicle_color']  	= $driver_obj->vehicle_color;
		$vehicle['vehicle_photos']  = '';
		$vehicle['registration_certificate']  = $domain . '/storage/' . $driver_obj->registration_certificate;
		$vehicle['insurance_certificate']  = $domain . '/storage/' . $driver_obj->vehicle_insurance;
		


		return apiResponse(1, 'Profile', $vehicle, 200);
		
	}
 
	public function uploadDL(UploadDoc $request, Drivers $driver)
	{
		$driver_obj = $request->login_detail;
		$login_driver_id = $driver_obj['login_id'];
		
		$frontPath = "drivers/{$login_driver_id}/uploads/dl/front";
        $backPath = "drivers/{$login_driver_id}/uploads/dl/back";
	
		if ($request->hasFile('dl_front')) {
            $dlFrontPath = $this->uploadDocService->store($request->file('dl_front'), $frontPath);
        }

        if ($request->hasFile('dl_back')) {
            $dlBackPath = $this->uploadDocService->store($request->file('dl_back'), $backPath);
        }

		$this->driverRepository->updateDLInfo($driver_obj, $dlFrontPath, $dlBackPath);
	
		return apiResponse(1, 'Driving License information updated successfully.', [
            'driving_licence' => implode(',', array_filter([$dlFrontPath, $dlBackPath]))
        ]);
	
	}	

	public function updateVehicleInfo(UploadDoc $request, Drivers $driver)
    {
		$login_detail = $request->login_detail;
        $login_driver_id = $login_detail['login_id'];

        $this->uploadDocService->updateDriver($login_detail, $request->validated());

		return apiResponse(1, 'Driver vehicle information updated successfully.', $login_detail, 200);
    }

	public function uploadRC(UploadDoc $request, Drivers $driver)
	{
		$login_detail = $request->login_detail;
        $login_driver_id = $login_detail['login_id'];
		$rcPath = "drivers/{$login_driver_id}/uploads/rc";
	
		if ($request->hasFile('registration_certificate')) {
            $rcPath = $this->uploadDocService->store($request->file('registration_certificate'), $rcPath);
        }

		$this->driverRepository->updateRCInfo($login_detail, $rcPath);
	
		return apiResponse(1, 'Registration Certificate upload successfully.', $rcPath, 200);
	
	}

	public function uploadInsurance(UploadDoc $request, Drivers $driver)
	{
		$login_detail = $request->login_detail;
		$login_driver_id = $login_detail['login_id'];
		$insurancePath = "drivers/{$login_driver_id}/uploads/insurance";
	
		if ($request->hasFile('vehicle_insurance')) {
            $insurancePath = $this->uploadDocService->store($request->file('vehicle_insurance'), $insurancePath);
        }

		$this->driverRepository->updateInsuranceInfo($login_detail, $insurancePath);
	
		return apiResponse(1, 'Vehicle Insurance upload successfully.', $insurancePath, 200);
	
	}

    public function earning(Request $request)
    {
        $login_detail = $request->login_detail;
        $earning = $this->uploadDocService->earning($login_detail['login_id']); 

        if($earning)
        return apiResponse(1, 'Earning Detail', $earning, 200);

        return apiResponse(0, 'There is no data.', '', 200);

    }

    public function vehicleTypeDropdown()
    {
        $carTypes = $this->carTypeService->getCarTypes(); 

        if($carTypes)
        return apiResponse(1, 'Car Types', $carTypes, 200);

        return apiResponse(0, 'There is no data.', '', 200);
    }	

    public function legalContent()
    {
        $legal_content = config('static_content.legal_content');
        return apiresponse(1, 'Legal Content', $legal_content, 200); 
    }

    public function terms()
    {
        $terms = config('static_content.terms');
        return apiresponse(1, 'Terms Condition', $terms, 200); 
    }

    public function privacyPolicy()
    {
        $privacy = config('static_content.privacy_policy');
        return apiresponse(1, 'Privacy Policy', $privacy, 200); 
    } 

    public function termsVerify(UploadDoc $request)
    {
        $login_detail = $request->login_detail;
        $login_driver_id = $login_detail['login_id'];
        $validated = $request->validated();
        

        $this->uploadDocService->updateTermsLegal($login_driver_id, $validated['status'], 'terms');       
        return apiresponse(1, 'Terms Verify', '', 200);
    }

    public function leagalVerify(UploadDoc $request)
    {
        $login_detail = $request->login_detail;
        $login_driver_id = $login_detail['login_id'];
        $validated = $request->validated();


        $this->uploadDocService->updateTermsLegal($login_driver_id, $validated['status'], 'legal');
        return apiresponse(1, 'Legal Verify', '', 200);
    }

    public function profileComplate(Request $request)
    {
        $login_detail = $request->login_detail;
        $login_driver_id = $login_detail['login_id'];

        $driver = $this->uploadDocService->checkAndUpdateProfileCompleteStatus($login_driver_id);
        if($driver->profile_complete)  
        return apiresponse(1, 'Profile is complete', '', 200);
        else
        return apiresponse(0, 'Profile is not complete, Must Required profile_photo, vehicle_insurance, vehicle_photo, driving_licence, registration_certificate', $driver, 200);
    } 
    
    public function isOnline(Request $request)
    {
        $login_detail = $request->login_detail;
        $driverId = $login_detail['login_id'];

        $driver_obj = $this->uploadDocService->onlineOffline($driverId);
        return apiresponse(1, '', $driver_obj, 200);

    }


}//
