<?php

namespace App\Http\Controllers\Api\Driver;

use App\Http\Controllers\Controller;
use App\Http\Requests\RatingRequest;
use App\Services\RatingService;
use Illuminate\Http\JsonResponse;

class RatingController extends Controller
{
    protected $ratingService;

    public function __construct(RatingService $ratingService)
    {
        $this->ratingService = $ratingService;
    }

    public function store(RatingRequest $request): JsonResponse
    {
        $data = $request->validated();
        $data_api = [];
        $data_api['user_id']        = $data['user_id'];
        $data_api['driver_id']      = $request->login_detail['login_id'];
        $data_api['trip_id']        = $data['parcel_id'];
        $data_api['rating_driver']  = $data['rating'];
        $data_api['comment_driver'] = $data['feedback'];

        $rating = $this->ratingService->saveRating($data_api);

        return apiResponse(1, 'Rating & Feedback submitted successfully.', $rating, 200);

        
    }
}

