<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Controller;

use App\Http\Requests\UserProfileUpdateRequest;
use App\Services\UserProfileService;
use Illuminate\Http\Request;

class ProfileController extends Controller
{
    protected $userProfileService;

    public function __construct(UserProfileService $userProfileService)
    {
        $this->userProfileService = $userProfileService;
    }

    public function update(UserProfileUpdateRequest $request)
    {
        $data = $request->validated();
        
        $user_login = $request->user_login;
        $userId = $user_login['login_id'];


        #\Log::info('Original Filename:', [$data]);

        if (isset($data['photo'])) {
        $file = $data['photo'];
        $originalName = $file->getClientOriginalName();
        $cleanedName = preg_replace('/\s+/', '_', trim($originalName));
        $filename = time() . '_' . $cleanedName;
        $path = $file->storeAs('uploads/profile_photos', $filename, 'custom_public');
        $data['photo'] = $path;
        }

        $user = $this->userProfileService->updateProfile($userId, $data);
        $user['photo_url'] = isset($user['photo']) && $user['photo'] ? asset('storage/'.$user['photo']) : defaultProfilePic();
        return apiResponse(1, 'Profile updated successfully', $user, 200);
    }

    public function show(Request $request)
    {
        $userId = $request->user_login['login_id'];
        $user = $this->userProfileService->getProfile($userId);

        return apiResponse(1, 'Profile updated successfully', $user, 200);
    }

    public function profileComplete(Request $request)
    {
        $userId = $request->user_login['login_id'];  
        $user_obj = $this->userProfileService->isProfileComplete($userId);

        $ret_data = [];
        $ret_data['is_complete'] = $user_obj->name && $user_obj->photo ? 1 : 0;
        $ret_data['screen_name'] = 'Profile'; 
        $ret_data['user_obj']   = $user_obj; 
        return apiresponse(1, 'is Complete', $ret_data, 200);
    }

    public function privacyPolicy()
    {
        $privacy = config('static_content.privacy_policy');
        return apiresponse(1, 'Privacy Policy', $privacy, 200);
    }     

    public function terms()
    {
        $terms = config('static_content.terms');
        return apiresponse(1, 'Terms Condition', $terms, 200);
    }

    public function aboutUs()
    {
        $terms = config('static_content.about_us');
        return apiresponse(1, 'About Us', $terms, 200);
    }
     
}
