<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Validator;
use App\Models\Passenger;

class PassengerController extends Controller
{
	public function index()
  	{
        $data = [];
        $url = url('/');
        $data['TYPE'] = 'admin';
  		return view('admin.passenger.index',$data);
	}

    public function index_ajax_passenger_list()
    {
        #logged_in();
        $status_array = array(0=>"Idle",1=>"Active",2=>"Delete");
        $recordsTotal = Passenger::count_all();
        $data = Passenger::get_data_table();
        if($data)
        {
            foreach ($data as $row)
            {
                $row->status_label = isset($status_array[$row->status]) ? $status_array[$row->status] : 'NA';
                if($row->photo){
                    $row->photo = url('').'/passenger/'.$row->photo;
                }
            }
        }
        $output = array(
                'status'=>1,
                'message'=>'success',
                "recordsTotal" => $recordsTotal,
                "recordsFiltered" => $recordsTotal,
                "data" => $data,
                );

        return Response::json($output, 200);
    }

    public function save(Request $request)
    {
        $customMessages = [
            'name' => 'My Name is Required',
        ];

        $id = $request->id;
        $validator = Validator::make($request->all(),[
            'name' => 'required',
            'email' => 'required|email|unique:passenger'. ($id ? ",email,$id" : ''),
            'mobile' => 'required',
        ], $customMessages);

        if($validator->fails())
              return $this->setValidatorError($validator,1);

        $path = public_path().'/passenger/';
        $photo = '';
        if($request->hasFile('photo')){
            $file = $request->file('photo');
            $photo = time() . '.' . $file->extension();
            $file->move($path, $photo);
        }
        if($request->id){
            $data =  Passenger::find($request->id);
        }else{
            $data = new Passenger;
        }
        $data->name = $request->name;
        $data->email = $request->email;
        $data->mobile = $request->mobile;
        if($photo){
            $data->photo = $photo;
        }
        $data->save();

        if($request->id){
            $msg = 'Updated';
        }else{
            $last_inserted_id = $data->id;
            $msg = 'Inserted';
        }

        return Response::json([
                        'status'  => true,
                        'message' => 'Customer '.$msg.' Successfully',
                        ]);

    }
}
