<?php

namespace App\Http\Controllers\Api\Driver;

use App\Models\Drivers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

use App\Http\Requests\FileUploadRequest;
use App\Services\FileUploadService;
use App\Repositories\DriverRepository;



class Profile extends Controller
{
    protected $fileUploadService;
    protected $driverRepository;

    public function __construct(FileUploadService $fileUploadService, DriverRepository $driverRepository)
    {
        $this->fileUploadService = $fileUploadService;
        $this->driverRepository = $driverRepository;
    }

    public function updateProfile(Request $request)
    {
        $validator = $this->validateRequest($request);

        if($validator->fails())
        return $this->setValidatorError($validator, 1);

        $validatedData = $validator->validated();

        $driver_obj = auth('api_driver')->user();
        if(!$driver_obj)
        return response()->json(['message' => 'There is no data.'], 400);

        $driver_login   = $driver_obj->toArray();
        $userDetail     = $this->updateDetail($validatedData, $driver_login);
       
        return response()->json([
            'message' => $userDetail['message'],
            //'data' => $validatedData
        ], 200); 
        
          
    }

    public function validateRequest(Request $request)
    {
        return Validator::make($request->all(), [
            'email' => 'required|email',
            'name' => 'required|string|max:50'
        ]);
    }

    private function updateDetail($validatedData, $driver_login)
    {
        $userDetail = Drivers::where('mobile', $driver_login['mobile'])->first();

        if ($userDetail) {
            $userDetail->update([
                'fname'  => $validatedData['name'],
                'email' => $validatedData['email'],
            ]);

            return ['message' => 'Details updated successfully.'];
        } 
    }

    public function updatec(FileUploadRequest $request)
    {
        //$validatedData = $request->validated();
         
        #$driver_obj = auth('api_driver')->user();
        #print_r($driver_obj); 
    }
    public function upload(FileUploadRequest $request, Drivers $driver)
    {
        $driver_obj     = auth('api_driver')->user();
        $driver_object = $driver_obj ? $driver_obj->toArray() : [];
        if(empty($driver_object['id']))
        {
        return response()->json([
            'success' => false,
            'message' => 'Login Required.',
            'data' => null
        ], 400); 
        }
     
        $files = [
            'registration_certificate'  => $request->file('registration_certificate') ? [$request->file('registration_certificate')] : [],
            'vehicle_insurance'         => $request->file('vehicle_insurance') ? [$request->file('vehicle_insurance')] : [],
            'driving_licence'           => $request->file('driving_licence') ? [$request->file('driving_licence')] : [],
            'profile_photo'             => $request->file('profile_photo') ? [$request->file('profile_photo')] : [],
            'vehicle_photo'             => $request->file('vehicle_photo') ? [$request->file('vehicle_photo')] : [],
        ];

        //\Log::info('vehicle_photo==', [$request->file('vehicle_photo')]);
 
        #$filePaths = $this->fileUploadService->uploadMultiple($request->only(['registration_certificate', 'vehicle_insurance', 'driving_licence', 'profile_photo']));
        $filePaths = $this->fileUploadService->uploadMultiple($files);
        $updatedDriver  = $this->driverRepository->save($driver, $filePaths, $request->all(), $driver_obj['id']);

        return response()->json([
            'success' => true,
            'message' => 'Files and vehicle information have been uploaded and saved successfully.',
            'data' => $updatedDriver
        ], 200);
    }  
        
}
