<?php

namespace App\Http\Middleware\Admin;

use Closure;
use Illuminate\Http\Request;

class redirectAdminLogin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $TYPE = 'admin';
        if (!app()->request->session()->has($TYPE)) {
            if($request->ajax()){
                return response()->json([
                        'status' => '0',
                        'message' => 'Login First',
                        'data'    => array(),
                ]);
            }
            return redirect()->route('admin.login');
        }

        return $next($request);
    }
}
