<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
//use Tymon\JWTAuth\Facades\JWTAuth;

class FileUploadRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'registration_certificate'  => 'required|mimes:pdf,jpg,jpeg,png|max:2048',
            'vehicle_insurance'         => 'required|mimes:pdf,jpg,jpeg,png|max:2048',
            'driving_licence'           => 'required|mimes:pdf,jpg,jpeg,png|max:2048',
            'profile_photo'             => 'required|mimes:jpg,jpeg,png|max:2048',
            'brand'                     => 'required|string|max:255',
            'model'                     => 'required|string|max:255',
            'year_of_manufacture'       => 'required|string|max:255',
            'vehicle_type'              => 'required|string|max:255',
            'registration_number'       => 'required|string|max:255',
            'vehicle_color'             => 'required|string|max:255',
            'vehicle_photo'             => 'nullable|mimes:webp,jpg,jpeg,png|max:2048',
            
        ];

    }

    
    protected function failedValidation(\Illuminate\Contracts\Validation\Validator $validator)
    {
        $errors = $validator->errors()->all();
        $response = response()->json([
            'status' => 'fail',
            'message' => 'Validation errors occurred.',
            'errors' => $errors
        ], 422);

        throw new \Illuminate\Validation\ValidationException($validator, $response);
    }

}
