<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class IncidentRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'driver_id' => 'nullable|exists:drivers,id',
            'message'   => 'required|string',
            'photos'    => 'required|array',
            'photos.*'  => 'image|mimes:jpg,jpeg,png,webp|max:20480',
        ];
    }

    protected function failedValidation(\Illuminate\Contracts\Validation\Validator $validator)
    {
        $errors = $validator->errors()->all();
        $response = response()->json([
            'status' => '0',
            'message' => 'Validation errors occurred.',
            'errors' => $errors
        ], 422);
        

        throw new \Illuminate\Validation\ValidationException($validator, $response);
    }
 
}

