<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class RatingRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'driver_id' => 'nullable|exists:drivers,id',
            'user_id'   => 'required|exists:users,id',
            'parcel_id' => 'required|exists:parcels,id',
            'rating'    => 'required|integer|min:1|max:5',
            'feedback'  => 'nullable|string|max:1000',
        ];
    }

    protected function failedValidation(\Illuminate\Contracts\Validation\Validator $validator)
    {
        $errors = $validator->errors()->all();
        $response = response()->json([
            'status' => '0',
            'message' => 'Validation errors occurred.',
            'errors' => $errors
        ], 422);
        

        throw new \Illuminate\Validation\ValidationException($validator, $response);
    }
 
}

