<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreBankDetailRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'bank_name'     => 'required|string',
            'holder_name'   => 'required|string',
            'account_number'=> 'required|string',
            'routing_number'=> 'required|string',
            'account_type'  => 'required|string'
        ];
    }

    protected function failedValidation(\Illuminate\Contracts\Validation\Validator $validator)
    {
        $errors = $validator->errors()->all();
        $response = response()->json([
            'status' => 'fail',
            'message' => 'Validation errors occurred.',
            'errors' => $errors
        ], 422);

        throw new \Illuminate\Validation\ValidationException($validator, $response);
    } 
}
