<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UserProfileUpdateRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'name'              => 'required|string|max:255',
            'email'             => 'required|email|max:255',
            'address'           => 'nullable|string|max:255',
            'emergency_number'  => 'nullable|numeric',
            'emergency_name'    => 'nullable|string',
            'emergency_message' => 'nullable|string',
            'photo'             => 'required|mimes:webp,jpg,jpeg,png|max:2048',
        ];
    }


    protected function failedValidation(\Illuminate\Contracts\Validation\Validator $validator)
    {
        $errors = $validator->errors()->all();
        $response = response()->json([
            'status' => 'fail',
            'message' => 'Validation errors occurred.',
            'errors' => $errors
        ], 422);

        throw new \Illuminate\Validation\ValidationException($validator, $response);
    }
}
