<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class Dashboard extends Model
{
    use HasFactory;

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Accessor for the 'created_at' attribute
    public function getCreatedAtAttribute($value)
    {
        return Carbon::parse($value)->format('Y-m-d H:i:s');
    }

    // Accessor for the 'updated_at' attribute
    public function getUpdatedAtAttribute($value)
    {
        return Carbon::parse($value)->format('Y-m-d H:i:s');
    }

    public function get_data_table()
    {
        $data = DB::table('wallet')
            ->join('drivers', 'wallet.driver_id', '=', 'drivers.id')
            ->select('wallet.*', 'name', 'email', 'mobile')
            ->orderBy('created_at', 'desc')
            ->get();
        return $data;
    }

    public function trips_stats()
    {
        $today_date = date('Y-m-d');
        $week_start_date = date('Y-m-d', strtotime('monday this week'));
        $week_end_date = date('Y-m-d');#date('Y-m-d', strtotime('sunday this week'));
        $first_date_of_month = date('Y-m-01');
        $last_date_of_month = date('Y-m-t');

        $current_day = date('d');
        $current_month = date('M');
        $current_week = date('d', strtotime('monday this week'));

        $today_date = '2024-09-29';
        $week_start_date = '2024-09-23';
        $week_end_date = '2024-09-29';
        $first_date_of_month = '2024-09-01';
        $last_date_of_month = '2024-09-30';

        $today = "SELECT status,count(*) AS cnt FROM parcels WHERE created_at >= '$today_date 00:00:00' AND created_at <= '$today_date 23:59:59' GROUP BY status";
        $week = "SELECT status,count(*) AS cnt FROM parcels WHERE created_at >= '$week_start_date 00:00:00' AND created_at <= '$week_end_date 23:59:59' GROUP BY status";
        $month = "SELECT status,count(*) AS cnt FROM parcels WHERE created_at >= '$first_date_of_month 00:00:00' AND created_at <= '$last_date_of_month 23:59:59' GROUP BY status";
        $overall = "SELECT status,count(*) AS cnt FROM parcels GROUP BY status";

        $today_obj = DB::select($today);
        $week_obj = DB::select($week);
        $month_obj = DB::select($month);
        $overall_obj = DB::select($overall);

        $trips = [
            'TODAY' => (object)[
                'Completed' => 0,
                'Cancelled' => 0,
                'Created' => 0,
                'ongoing' => 0,
                'Date' => $current_month.' '. $current_day,
            ],
            'WEEK' => (object)[
                'Completed' => 0,
                'Cancelled' => 0,
                'Created' => 0,
                'ongoing' => 0,
                'Date' => $current_month.' '. $current_week,
            ],
            'MONTH' => (object)[
                'Completed' => 0,
                'Cancelled' => 0,
                'Created' => 0,
                'ongoing' => 0,
                'Date' => $current_month,
            ],
            'OVERALL' => (object)[
                'Completed' => 0,
                'Cancelled' => 0,
                'Created' => 0,
                'ongoing' => 0,
                'Date' => '',
            ]
        ];

        self::populateTrips($today_obj, $trips, 'TODAY');
        self::populateTrips($week_obj, $trips, 'WEEK');
        self::populateTrips($month_obj, $trips, 'MONTH');
        self::populateTrips($overall_obj, $trips, 'OVERALL');
        return $trips;
    }

    function populateTrips($data, &$trips, $period)
    {
        foreach ($data as $item) {
            if ($item->status == 4) {
                $trips[$period]->Completed += $item->cnt;
                $trips[$period]->Created += $item->cnt;
            } elseif ($item->status == 5) {
                $trips[$period]->Cancelled += $item->cnt;
                $trips[$period]->Created += $item->cnt;
            } else{
                $trips[$period]->Created += $item->cnt;
            }
        }
    }

    public function payments_stats()
    {
        $today_date = date('Y-m-d');
        $week_start_date = date('Y-m-d', strtotime('monday this week'));
        $week_end_date = date('Y-m-d');#date('Y-m-d', strtotime('sunday this week'));
        $first_date_of_month = date('Y-m-01');
        $last_date_of_month = date('Y-m-t');

        $current_day = date('d');
        $current_month = date('M');
        $current_week = date('d', strtotime('monday this week'));

        $today_date = '2024-09-29';
        $week_start_date = '2024-09-23';
        $week_end_date = '2024-09-29';
        $first_date_of_month = '2024-09-01';
        $last_date_of_month = '2024-09-30';

        $today = "SELECT payment_type,SUM(payment) AS payment FROM parcels WHERE created_at >= '$today_date 00:00:00' AND created_at <= '$today_date 23:59:59' AND status = 4 GROUP BY payment_type";
        $week = "SELECT payment_type,SUM(payment) AS payment FROM parcels WHERE created_at >= '$week_start_date 00:00:00' AND created_at <= '$week_end_date 23:59:59' AND status = 4 GROUP BY payment_type";
        $month = "SELECT payment_type,SUM(payment) AS payment FROM parcels WHERE created_at >= '$first_date_of_month 00:00:00' AND created_at <= '$last_date_of_month 23:59:59' AND status = 4 GROUP BY payment_type";

        $today_obj = DB::select($today);
        $week_obj = DB::select($week);
        $month_obj = DB::select($month);

        $payments = [
            'TODAY' => (object)[
                'Cash' => 0,
                'Online' => 0,
                'Total' => 0,
                'Date' => $current_month.' '. $current_day,
            ],
            'WEEK' => (object)[
                'Cash' => 0,
                'Online' => 0,
                'Total' => 0,
                'Date' => $current_month.' '. $current_week,
            ],
            'MONTH' => (object)[
                'Cash' => 0,
                'Online' => 0,
                'Total' => 0,
                'Date' => $current_month,
            ]
        ];

        self::populatePayments($today_obj, $payments, 'TODAY');
        self::populatePayments($week_obj, $payments, 'WEEK');
        self::populatePayments($month_obj, $payments, 'MONTH');
        return $payments;
    }

    function populatePayments($data, &$payments, $period) 
    {
        foreach ($data as $item) {
            if ($item->payment_type == 1) {
                $payments[$period]->Cash += $item->payment;
            } elseif ($item->payment_type == 2) {
                $payments[$period]->Online += $item->payment;
            }
        }
        $payments[$period]->Total = $payments[$period]->Cash + $payments[$period]->Online;
    }

    public function drivers_stats()
    {
        $verified = DB::table('drivers')
            ->select('verified', DB::raw('count(*) as cnt'))
            ->groupBy('verified')
            ->get();
        
        $total = DB::table('drivers')
            ->select(DB::raw('count(*) as cnt'))
            ->first();

        $availability = DB::table('drivers')
            ->select(DB::raw('count(*) as cnt'))
            ->where('availability',1)
            ->first();

        $active = DB::table('drivers')
            ->select(DB::raw('count(*) as cnt'))
            ->where('status','1')
            ->first();

        $inactive = DB::table('drivers')
            ->select(DB::raw('count(*) as cnt'))
            ->where('status','0')
            ->first();

        $drivers = [
            'Verified' => (object)[
                'status' => 0,
                'cnt' => 0,
            ],
            'Unverified' => (object)[
                'status' => 1,
                'cnt' => 0,
            ],
            'active' => (object)[
                'status' => 1,
                'cnt' => 0,
            ],
            'inactive' => (object)[
                'status' => 0,
                'cnt' => 0,
            ],
            'Available' => (object)[
                'status' => 8888,
                'cnt' => 0,
            ],
            'Total' => (object)[
                'status' => 9999,
                'cnt' => 0,
            ]
        ];
        $associativeArray = [];
        if($verified){
            foreach ($verified as $item) {
                $associativeArray[$item->verified] = $item->cnt;
            }
        }
        if($total){
            $drivers['Total']->cnt = $total->cnt;
        }
        if($availability){
            $drivers['Available']->cnt = $total->cnt;
        }
        return $drivers;
    }

    public function users_stats()
    {
        $data = DB::table('users')
            ->select('status', DB::raw('count(*) as cnt'))
            ->groupBy('status')
            ->get();

        $users = [
            'Inactive' => (object)[
                'status' => 0,
                'cnt' => 0,
            ],
            'Active' => (object)[
                'status' => 1,
                'cnt' => 0,
            ],
            'Deleted' => (object)[
                'status' => 2,
                'cnt' => 0,
            ],
            'Total' => (object)[
                'status' => 9999,
                'cnt' => 0,
            ]
        ];
        $associativeArray = [];
        if($data){
            foreach ($data as $item) {
                $associativeArray[$item->status] = $item->cnt;
            }
        }
        $total = 0;
        foreach($users as $key=>$i){
            if(isset($associativeArray[$i->status])){
                $i->cnt = $associativeArray[$i->status];
                $total+=$associativeArray[$i->status];
            }
        }
        $users['Total']->cnt=$total;
        return $users;
    }

    public function top_drivers()
    {
        $data = DB::table('parcels as p')
            ->join('drivers as d', 'p.driver_id', '=', 'd.id')
            ->select('p.driver_id', 'name', 
                DB::raw('SUM(p.payment) AS payment'),
                DB::raw('COUNT(*) AS tour')
            )
            ->where('p.status',4)
            ->groupBy('p.driver_id')
            ->orderBy('tour', 'desc')
            ->take(10)
            ->get();
        return $data;
    }
}
