<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\Parcel;
use App\Models\Drivers;

class ParcelRequest extends Model
{

    use HasFactory;

    protected $table = 'parcel_requests';

    protected $fillable = [
        'parcel_id',
        'driver_id',
        'status',
        'cancellation_reason'
    ];

    public function parcel()
    {
        return $this->belongsTo(Parcels::class, 'parcel_id');
    }

    public function driver()
    {
        return $this->belongsTo(Drivers::class, 'driver_id');
    } 
} 
