<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class Rating extends Model
{
    use HasFactory;
    protected $table = 'rating';

    protected $fillable = [
        'user_id',       
        'driver_id',     
        'trip_id',       
        'rating_driver', 
        'comment_driver'

    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

////DHEERU/////
    public function driver()
    {
        return $this->belongsTo(Drivers::class);
    }

    public function user()
    {
        return $this->belongsTo(Users::class);
    }

/////////

    // Accessor for the 'created_at' attribute
    public function getCreatedAtAttribute($value)
    {
        return Carbon::parse($value)->format('Y-m-d H:i:s');
    }

    // Accessor for the 'updated_at' attribute
    public function getUpdatedAtAttribute($value)
    {
        return Carbon::parse($value)->format('Y-m-d H:i:s');
    }

    public function get_data_table()
    {
        $data = DB::table('rating')
            ->leftJoin('users', 'rating.user_id', '=', 'users.id')
            ->leftJoin('drivers', 'rating.driver_id', '=', 'drivers.id')
            ->select('rating.*', 'drivers.name as drivers_name', 'drivers.email as drivers_email', 'drivers.mobile as drivers_mobile', 'users.name as users_name', 'users.email as users_email', 'users.mobile as users_mobile')
            ->orderBy('created_at', 'desc')
            ->get();
        return $data;
    }
    
    public function count_all()
    {
        $count = Rating::count();
        return $count;
    }
}
