<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class Trip extends Model
{
    use HasFactory;
    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Accessor for the 'created_at' attribute
    public function getCreatedAtAttribute($value)
    {
        return Carbon::parse($value)->format('Y-m-d H:i:s');
    }

    // Accessor for the 'updated_at' attribute
    public function getUpdatedAtAttribute($value)
    {
        return Carbon::parse($value)->format('Y-m-d H:i:s');
    }

    public function get_data_table()
    {
        $data = DB::table('parcels')
            ->join('users', 'parcels.user_id', '=', 'users.id')
            ->leftJoin('drivers', 'parcels.driver_id', '=', 'drivers.id')
            ->select('parcels.*', 'drivers.name as drivers_name', 'drivers.email as drivers_email', 'drivers.mobile as drivers_mobile', 'users.name as users_name', 'users.email as users_email', 'users.mobile as users_mobile')
            ->orderBy('created_at', 'desc')
            ->get();
        return $data;
    }
    
    public function count_all()
    {
        $count = Trip::count();
        return $count;
    }
}
